/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.mail.entity.mail_service.payback_department;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.util.Ticks;
import io.github.mortuusars.envelope.world.delivery.Delivery;
import io.github.mortuusars.envelope.world.delivery.phase.DeliveryPhase;
import io.github.mortuusars.envelope.world.item.PaybackPackageItem;
import io.github.mortuusars.envelope.world.item.PaybackPackingBoxItem;
import io.github.mortuusars.envelope.world.item.component.Id;
import io.github.mortuusars.envelope.world.item.component.PackageContents;
import io.github.mortuusars.envelope.world.item.component.RequestedPayback;
import io.github.mortuusars.envelope.world.item.component.mail.log.DeliveryRecord;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import io.github.mortuusars.envelope.world.item.mail.MailBuilder;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.entity.mail_service.payback_department.PaybackDepartmentData;
import io.github.mortuusars.envelope.world.mail.entity.mail_service.payback_department.PaybackSubject;
import io.github.mortuusars.envelope.world.service.MailService;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class PaybackDepartment {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final MailService mailService;
    @Nullable
    private PaybackDepartmentData data = null;

    public PaybackDepartment(MailService context) {
        this.mailService = context;
    }

    public MailService getMailService() {
        return this.mailService;
    }

    @NotNull
    public PaybackDepartmentData getData() {
        if (this.data == null) {
            this.data = PaybackDepartmentData.get(this.mailService.getLevel(), "mail_service_payback_department");
        }
        return this.data;
    }

    public int getPendingPaybackSubjectCount() {
        return this.getData().getPaybackPendingSubjects().size();
    }

    @Nullable
    protected PaybackSubject getPendingPaybackSubject(Id id) {
        return this.getData().getPaybackPendingSubjects().get(id);
    }

    @Nullable
    protected PaybackSubject removePendingPaybackSubject(Id id) {
        @Nullable PaybackSubject subject = this.getData().getPaybackPendingSubjects().remove(id);
        if (subject != null) {
            this.getData().method_80();
        }
        return subject;
    }

    protected long getPaybackTimeoutTicksFor(class_1799 mail) {
        return Ticks.fromMinutes(((Integer)Config.Server.DELIVERY_PAYBACK_TIMEOUT_MINUTES.get()).intValue());
    }

    protected void awaitPayback(PaybackSubject paybackSubject) {
        this.getData().getPaybackPendingSubjects().put(paybackSubject.id(), paybackSubject);
        this.getData().method_80();
    }

    public void tick() {
        if (this.getMailService().getGameTime() % 200L == 0L) {
            this.getData().getPaybackPendingSubjects().entrySet().removeIf(entry -> {
                if (((PaybackSubject)entry.getValue()).timeoutTick() <= this.getMailService().getGameTime()) {
                    this.returnSubjectToSender((PaybackSubject)entry.getValue(), DeliveryRecord.Message.RETURNED_PAYBACK_EXPIRED);
                    this.getData().method_80();
                    return true;
                }
                return false;
            });
        }
    }

    public int returnAllAwaitingAsTimedOut() {
        int count = 0;
        for (PaybackSubject subject : this.getData().getPaybackPendingSubjects().values()) {
            if (!this.returnSubjectToSender(subject, DeliveryRecord.Message.RETURNED_PAYBACK_EXPIRED)) continue;
            ++count;
        }
        this.getData().getPaybackPendingSubjects().clear();
        this.getData().method_80();
        return count;
    }

    public boolean returnSubjectToSender(PaybackSubject subject, class_2561 reason) {
        class_1799 mail = subject.mail();
        Mail.setReturned(mail);
        Mail.writeToLog(mail, DeliveryRecord.returned(reason), DeliveryRecord.sentFrom(Address.MAIL_SERVICE, this.getMailService().getGameTime()));
        return this.getMailService().getDeliveryManager().startService(Delivery.draft().deliver(mail).from(Address.MAIL_SERVICE).to(subject.returnAddress()).startAtPhase(DeliveryPhase.TRAVELING_FROM_HUB_TO_RECIPIENT)).ifError(error -> LOGGER.info("Cannot return subject of [{}] with id [{}] back to sender.", (Object)subject.mail().method_7964().getString(), (Object)subject.id())).isSuccess();
    }

    public boolean tryHandleDelivery(Delivery delivery) {
        if (delivery.getMail().method_57826(Envelope.DataComponents.MAIL_REQUESTED_PAYBACK)) {
            this.handlePaybackSubject(delivery);
            return true;
        }
        if (delivery.getMail().method_7909() instanceof PaybackPackageItem) {
            this.handlePaybackPayment(delivery);
            return true;
        }
        return false;
    }

    public boolean tryHandleReturn(Delivery delivery) {
        if (delivery.getMail().method_7909() instanceof PaybackPackingBoxItem) {
            @Nullable PaybackSubject subject = (PaybackSubject)delivery.getMail().method_57824(Envelope.DataComponents.PAYBACK_SUBJECT);
            if (subject == null) {
                LOGGER.info("Returning Payback Packing Box does not have a subject linked. Packing Box will be voided.");
                delivery.setMail(class_1799.field_8037);
                delivery.setPhaseAndResetProgress(DeliveryPhase.FINISHED);
                return true;
            }
            @Nullable PaybackSubject storedSubject = this.removePendingPaybackSubject(subject.id());
            if (storedSubject == null) {
                LOGGER.info("Returning Payback Packing Box links to subject of [{}] with id [{}], which is not found in storage. Packing Box will be voided.", (Object)subject.mail().method_7964().getString(), (Object)subject.id());
                delivery.setMail(class_1799.field_8037);
                delivery.setPhaseAndResetProgress(DeliveryPhase.FINISHED);
                return true;
            }
            if (this.returnSubjectToSender(storedSubject, DeliveryRecord.Message.RECIPIENT_NOT_FOUND)) {
                LOGGER.info("Pending payback subject of [{}] with id [{}] was returned to sender, as Payback Packing Box couldn't be delivered to recipient.", (Object)subject.mail().method_7964().getString(), (Object)subject.id());
            }
            delivery.setMail(class_1799.field_8037);
            delivery.setPhaseAndResetProgress(DeliveryPhase.FINISHED);
            return true;
        }
        return false;
    }

    protected void handlePaybackSubject(Delivery subjectDelivery) {
        Preconditions.checkArgument((boolean)subjectDelivery.getMail().method_57826(Envelope.DataComponents.MAIL_REQUESTED_PAYBACK));
        class_1799 subject = subjectDelivery.getMail();
        Mail.writeToLog(subject, DeliveryRecord.arrivedTo(Address.MAIL_SERVICE, this.getMailService().getGameTime()));
        Id subjectId = Id.create((class_1937)this.getMailService().getLevel());
        long timeoutTick = this.getMailService().getGameTime() + this.getPaybackTimeoutTicksFor(subject);
        PaybackSubject paybackSubject = new PaybackSubject(subjectId, subject, subjectDelivery.getSender(), timeoutTick);
        if (this.sendPaybackPackingBoxToBuyer(subjectDelivery, paybackSubject)) {
            this.awaitPayback(paybackSubject);
            subjectDelivery.setMail(class_1799.field_8037);
        } else {
            Mail.writeToLog(subject, DeliveryRecord.returned(DeliveryRecord.Message.RETURNED_PAYBACK_IS_NOT_VALID), DeliveryRecord.sentFrom(Address.MAIL_SERVICE, this.getMailService().getGameTime()));
        }
        subjectDelivery.setPhaseAndResetProgress(DeliveryPhase.TRAVELING_FROM_HUB_TO_SENDER);
    }

    protected boolean sendPaybackPackingBoxToBuyer(Delivery subjectDelivery, PaybackSubject paybackSubject) {
        class_1799 packingBox = ((MailBuilder)((MailBuilder)((MailBuilder)Mail.createPaybackPackingBox(paybackSubject).sender(subjectDelivery.getSender())).recipient(subjectDelivery.getRecipient())).writeToLog(DeliveryRecord.sentFrom(Address.MAIL_SERVICE, subjectDelivery.getId().getTick()))).get();
        return this.getMailService().getDeliveryManager().startService(Delivery.draft().deliver(packingBox).from(subjectDelivery.getSender()).to(subjectDelivery.getRecipient()).startAtPhase(DeliveryPhase.DISPATCHING_DELIVERY)).isSuccess();
    }

    protected void handlePaybackPayment(Delivery paybackDelivery) {
        PackageContents packageContents;
        class_1799 paybackPackage = paybackDelivery.getMail();
        Mail.writeToLog(paybackPackage, DeliveryRecord.arrivedTo(Address.MAIL_SERVICE, this.getMailService().getGameTime()));
        @Nullable PaybackSubject paybackSubject = (PaybackSubject)paybackPackage.method_57824(Envelope.DataComponents.PAYBACK_SUBJECT);
        if (paybackSubject == null) {
            Mail.writeToLog(paybackPackage, DeliveryRecord.returned(DeliveryRecord.Message.RETURNED_PAYBACK_SUBJECT_NOT_FOUND), DeliveryRecord.sentFrom(Address.MAIL_SERVICE, this.getMailService().getGameTime()));
            paybackDelivery.setPhaseAndResetProgress(DeliveryPhase.TRAVELING_FROM_HUB_TO_SENDER);
            return;
        }
        if ((paybackSubject = this.getPendingPaybackSubject(paybackSubject.id())) == null) {
            Mail.writeToLog(paybackPackage, DeliveryRecord.returned(DeliveryRecord.Message.RETURNED_PAYBACK_SUBJECT_NOT_FOUND), DeliveryRecord.sentFrom(Address.MAIL_SERVICE, this.getMailService().getGameTime()));
            paybackDelivery.setPhaseAndResetProgress(DeliveryPhase.TRAVELING_FROM_HUB_TO_SENDER);
            return;
        }
        if (!paybackDelivery.getRecipient().equals(paybackSubject.returnAddress())) {
            Mail.writeToLog(paybackPackage, DeliveryRecord.returned(DeliveryRecord.Message.RETURNED_PAYBACK_SUBJECT_NOT_FOUND), DeliveryRecord.sentFrom(Address.MAIL_SERVICE, this.getMailService().getGameTime()));
            paybackDelivery.setPhaseAndResetProgress(DeliveryPhase.TRAVELING_FROM_HUB_TO_SENDER);
            return;
        }
        RequestedPayback requestedPayback = (RequestedPayback)paybackSubject.mail().method_57825(Envelope.DataComponents.MAIL_REQUESTED_PAYBACK, (Object)RequestedPayback.DEFAULT);
        if (!requestedPayback.matches(packageContents = PackageContents.from(paybackPackage))) {
            Mail.writeToLog(paybackPackage, DeliveryRecord.returned(DeliveryRecord.Message.RETURNED_PAYBACK_IS_NOT_VALID), DeliveryRecord.sentFrom(Address.MAIL_SERVICE, this.getMailService().getGameTime()));
            paybackDelivery.setPhaseAndResetProgress(DeliveryPhase.TRAVELING_FROM_HUB_TO_SENDER);
            return;
        }
        if (!this.sendPaymentPackageToSeller(paybackDelivery, packageContents, paybackPackage)) {
            Mail.writeToLog(paybackPackage, DeliveryRecord.returned(DeliveryRecord.Message.RETURNED_PAYBACK_IS_NOT_VALID), DeliveryRecord.sentFrom(Address.MAIL_SERVICE, this.getMailService().getGameTime()));
            paybackDelivery.setPhaseAndResetProgress(DeliveryPhase.TRAVELING_FROM_HUB_TO_SENDER);
            return;
        }
        this.removePendingPaybackSubject(paybackSubject.id());
        this.sendSubjectToBuyerUsingSameDelivery(paybackDelivery, paybackSubject);
    }

    protected void sendSubjectToBuyerUsingSameDelivery(Delivery paybackDelivery, @NotNull PaybackSubject paybackSubject) {
        class_1799 subject = ((MailBuilder)((MailBuilder)((MailBuilder)Mail.of(paybackSubject.mail()).sender(paybackSubject.returnAddress())).writeToLog(DeliveryRecord.payback(DeliveryRecord.Message.PAYBACK_FULFILLED, DeliveryRecord.MessageType.POSITIVE))).writeToLog(DeliveryRecord.sentFrom(Address.MAIL_SERVICE, this.mailService.getGameTime()))).get();
        paybackDelivery.setMail(subject);
        paybackDelivery.setPhaseAndResetProgress(DeliveryPhase.TRAVELING_FROM_HUB_TO_SENDER);
    }

    protected boolean sendPaymentPackageToSeller(Delivery paybackDelivery, PackageContents packageContents, class_1799 paybackPackage) {
        class_1799 paymentPackage = ((MailBuilder)((MailBuilder)((MailBuilder)((MailBuilder)((MailBuilder)Mail.createPackage(packageContents).sender(paybackDelivery.getSender())).recipient(paybackDelivery.getRecipient())).setLog(Mail.getLog(paybackPackage))).writeToLog(DeliveryRecord.payback(DeliveryRecord.Message.PAYBACK_FULFILLED, DeliveryRecord.MessageType.POSITIVE))).writeToLog(DeliveryRecord.sentFrom(Address.MAIL_SERVICE, this.mailService.getGameTime()))).get();
        return this.getMailService().getDeliveryManager().startService(Delivery.draft().deliver(paymentPackage).from(paybackDelivery.getSender()).to(paybackDelivery.getRecipient()).startAtPhase(DeliveryPhase.DISPATCHING_DELIVERY)).isSuccess();
    }
}

