/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.mail.receiver;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.envelope.world.block.mailbox.Inbox;
import io.github.mortuusars.envelope.world.block.mailbox.InboxStorage;
import io.github.mortuusars.envelope.world.item.component.Id;
import io.github.mortuusars.envelope.world.item.component.mail.log.DeliveryRecord;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.receiver.MailReceiver;
import io.github.mortuusars.envelope.world.service.MailService;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import org.slf4j.Logger;

public class MailboxMailReceiver
implements MailReceiver {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Address.Block address;

    public MailboxMailReceiver(Address.Block address) {
        this.address = address;
    }

    @Override
    public class_1799 receiveMail(class_3218 level, class_1799 mail) {
        if (mail.method_7960()) {
            return class_1799.field_8037;
        }
        return MailboxMailReceiver.getInboxByAddress(level, this.address).map(inbox -> {
            if (inbox.isInboxFull()) {
                LOGGER.info("Cannot deliver mail to mailbox '{}': inbox is full. Returning to sender.", (Object)this.address);
                return this.returned(mail, DeliveryRecord.Message.RECIPIENT_INBOX_IS_FULL);
            }
            class_1799 deliveredMail = Mail.asDelivered(mail.method_46651(1));
            Mail.writeToLog(deliveredMail, DeliveryRecord.arrivedTo(this.address, level.method_8510()));
            Mail.setId(deliveredMail, Id.create((class_1937)level));
            if (inbox.addMail(deliveredMail)) {
                inbox.onMailInserted(deliveredMail);
                return class_1799.field_8037;
            }
            LOGGER.info("Cannot deliver mail to mailbox '{}': mail cannot be inserted. Returning to sender.", (Object)this.address);
            return this.returned(mail, DeliveryRecord.Message.UNABLE_TO_REACH);
        }).orElseGet(() -> {
            LOGGER.info("Cannot deliver mail to mailbox '{}': address not found. Returning to sender.", (Object)this.address);
            return this.returned(mail, DeliveryRecord.Message.RECIPIENT_NOT_FOUND);
        });
    }

    public static Optional<Inbox> getInboxByAddress(class_3218 level, Address.Block address) {
        return MailService.of(level).getMailboxes().getBlockEntityOf(address).map(blockEntity -> blockEntity).or(() -> InboxStorage.get(level).getForDelivery(address));
    }
}

