/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.service;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.envelope.util.result.Error;
import io.github.mortuusars.envelope.util.result.Result;
import io.github.mortuusars.envelope.world.delivery.Courier;
import io.github.mortuusars.envelope.world.delivery.Delivery;
import io.github.mortuusars.envelope.world.delivery.DeliveryDraft;
import io.github.mortuusars.envelope.world.delivery.route.DeliveryRoute;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.service.MailService;
import java.util.function.Function;
import net.minecraft.class_1937;
import org.slf4j.Logger;

public class DeliveryManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Error ERROR_NO_MAIL = new Error("Mail is empty.", "error.envelope.delivery.no_mail");
    private static final Error ERROR_SAME_ADDRESSES = new Error("Recipient address cannot be the same as sender address.", "error.envelope.delivery.same_addresses");
    private static final Error ERROR_RECIPIENT_UNKNOWN = new Error("Cannot deliver to unknown address.", "error.envelope.delivery.unknown_address");
    private final MailService mailService;

    public DeliveryManager(MailService mailService) {
        this.mailService = mailService;
    }

    public MailService getMailService() {
        return this.mailService;
    }

    public Result<StartedDelivery> start(Pigeon pigeon, DeliveryDraft draft) {
        return this.tryStart(draft, pigeon::startDelivery);
    }

    public Result<StartedDelivery> startService(DeliveryDraft draft) {
        return this.tryStart(draft, delivery -> Pigeon.spawnServiceCourier(this.getMailService().getLevel(), delivery));
    }

    protected Result<StartedDelivery> tryStart(DeliveryDraft draft, Function<Delivery, Courier> courier) {
        if (draft.getMail().method_7960()) {
            LOGGER.error("Cannot start delivery: {}. Delivery: {}", (Object)ERROR_NO_MAIL.getMessage(), (Object)draft);
            return Result.error(ERROR_NO_MAIL);
        }
        Delivery delivery = new Delivery(draft.getOrCreateId((class_1937)this.getMailService().getLevel()), draft.getOwner(), draft.getSender(), draft.getRecipient(), draft.getMail(), DeliveryRoute.build(this.getMailService().getLevel(), draft.getSender(), draft.getRecipient()), draft.getPhase(), 0, false);
        LOGGER.debug("Starting delivery: {}", (Object)delivery);
        return Result.success(new StartedDelivery(courier.apply(delivery), delivery));
    }

    public boolean canDeliverTo(Address address) {
        if (address.matches(Address.UNKNOWN)) {
            return false;
        }
        Address resolvedAddress = this.getMailService().resolve(address);
        if (resolvedAddress instanceof Address.Player) {
            return false;
        }
        return this.getMailService().getKnownAddresses().isKnown(resolvedAddress);
    }

    public record StartedDelivery(Courier courier, Delivery delivery) {
    }
}

