/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.service;

import com.google.common.base.Preconditions;
import io.github.mortuusars.envelope.util.bugger.Bugger;
import io.github.mortuusars.envelope.util.result.Result;
import io.github.mortuusars.envelope.world.block.mailbox.Mailboxes;
import io.github.mortuusars.envelope.world.delivery.Delivery;
import io.github.mortuusars.envelope.world.delivery.background.BackgroundDelivery;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import io.github.mortuusars.envelope.world.item.mail.MailBuilder;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.address.AddressLocation;
import io.github.mortuusars.envelope.world.mail.address.AllAddresses;
import io.github.mortuusars.envelope.world.mail.entity.MailEntities;
import io.github.mortuusars.envelope.world.mail.entity.MailEntity;
import io.github.mortuusars.envelope.world.mail.entity.mail_service.MailServiceEntity;
import io.github.mortuusars.envelope.world.mail.entity.mail_service.payback_department.PaybackDepartment;
import io.github.mortuusars.envelope.world.mail.receiver.EntityMailReceiver;
import io.github.mortuusars.envelope.world.mail.receiver.MailboxMailReceiver;
import io.github.mortuusars.envelope.world.mail.receiver.PlayerMailReceiver;
import io.github.mortuusars.envelope.world.service.DeliveryManager;
import io.github.mortuusars.envelope.world.service.Players;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_9334;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MailService {
    protected final class_3218 level;
    protected final Mailboxes mailboxes;
    protected final MailEntities mailEntities;
    protected final MailServiceEntity mailServiceEntity;
    protected final PaybackDepartment paybackDepartment;
    protected final DeliveryManager deliveryManager;
    @Nullable
    protected Players players;
    @Nullable
    protected BackgroundDelivery backgroundDelivery;

    private MailService(class_3218 level) {
        Preconditions.checkArgument((level.method_27983() == class_1937.field_25179 ? 1 : 0) != 0, (Object)"MailService can exist only on overworld level.");
        this.level = level;
        this.mailboxes = new Mailboxes(level);
        this.mailEntities = new MailEntities();
        this.mailServiceEntity = new MailServiceEntity(this);
        this.paybackDepartment = new PaybackDepartment(this);
        this.deliveryManager = new DeliveryManager(this);
        this.mailEntities.register(this.mailServiceEntity);
    }

    @ApiStatus.Internal
    public static MailService create(class_3218 level) {
        return new MailService(level);
    }

    public static MailService of(class_3218 level) {
        return level.getEnvelopeMailService();
    }

    public class_3218 getLevel() {
        return this.level;
    }

    public Mailboxes getMailboxes() {
        return this.mailboxes;
    }

    public MailEntities getMailEntities() {
        return this.mailEntities;
    }

    public MailServiceEntity getMailService() {
        return this.mailServiceEntity;
    }

    public PaybackDepartment getPaybackDepartment() {
        return this.paybackDepartment;
    }

    @NotNull
    public Players getPlayers() {
        return this.players == null ? (this.players = Players.get(this.level, "envelope_players")) : this.players;
    }

    @NotNull
    public BackgroundDelivery getBackgroundDelivery() {
        return this.backgroundDelivery == null ? (this.backgroundDelivery = BackgroundDelivery.get(this.level, "envelope_background_delivery")) : this.backgroundDelivery;
    }

    public DeliveryManager getDeliveryManager() {
        return this.deliveryManager;
    }

    public AllAddresses getKnownAddresses() {
        return new AllAddresses(this.getMailboxes().getAllAddresses(), this.getPlayers().getDefaultAddresses().keySet(), this.getMailEntities().getAllAddresses());
    }

    public AllAddresses getKnownAddressesOfType(@Nullable Address.Type type) {
        if (type == null) {
            return this.getKnownAddresses();
        }
        return switch (type) {
            default -> throw new MatchException(null, null);
            case Address.Type.BLOCK -> AllAddresses.blocks(this.getMailboxes().getAllAddresses());
            case Address.Type.PLAYER -> AllAddresses.players(this.getPlayers().getDefaultAddresses().keySet());
            case Address.Type.ENTITY -> AllAddresses.entities(this.getMailEntities().getAllAddresses());
        };
    }

    public Optional<Address.Block> getPlayerDefaultAddress(Address.Player playerAddress) {
        return Optional.ofNullable(this.getPlayers().getDefaultAddresses().get(playerAddress));
    }

    public Address resolve(Address address) {
        if (address instanceof Address.Player) {
            Address.Player playerAddress = (Address.Player)address;
            return this.getPlayerDefaultAddress(playerAddress).map(Address.class::cast).orElse(address);
        }
        return address;
    }

    public AddressLocation getLocationOf(Address address) {
        return address.map(block -> this.getMailboxes().getPositionOf((Address.Block)block).map(AddressLocation::exact), player -> this.getPlayers().getDefaultAddressOf((Address.Player)player).map(this::getLocationOf), entity -> this.getMailEntities().byAddress((Address.Entity)entity).map(MailEntity::getLocation)).orElse(AddressLocation.UNKNOWN);
    }

    public class_1799 deliverMail(Address address, class_1799 mail) {
        if (mail.method_7960()) {
            return mail;
        }
        return address.map(MailboxMailReceiver::new, PlayerMailReceiver::new, EntityMailReceiver::new).receiveMail(this.level, mail);
    }

    public void tick() {
        this.getBackgroundDelivery().tick(this.level);
        this.getPaybackDepartment().tick();
        if (this.level.method_8510() % 20L == 0L) {
            Bugger.MAIL_SERVICE.collectAndSendData(this);
        }
    }

    public long getGameTime() {
        return this.getLevel().method_8510();
    }

    public static boolean operatesIn(class_1937 level) {
        return level.method_27983() == class_1937.field_25179;
    }

    public Result<DeliveryManager.StartedDelivery> sendCourierDeathNotice(class_1309 entity, Delivery delivery, class_1282 damageSource) {
        Address address = delivery.getSender();
        if (!(address instanceof Address.Block)) {
            return null;
        }
        Address.Block address2 = (Address.Block)address;
        class_1799 letter = this.createCourierDeathNoticeLetter(entity, delivery, damageSource);
        return this.getDeliveryManager().startService(Delivery.draft().deliver(letter).from(Address.MAIL_SERVICE).to(address2));
    }

    public class_1799 createCourierDeathNoticeLetter(class_1309 entity, Delivery delivery, class_1282 damageSource) {
        class_5250 text = class_2561.method_43473().method_10852((class_2561)class_2561.method_43471((String)"letter.envelope.courier_death_notice.title").method_27692(class_124.field_1056)).method_10852((class_2561)class_2561.method_43469((String)("letter.envelope.courier_death_notice.inform_" + entity.method_59922().method_43048(5)), (Object[])new Object[]{damageSource.method_5506(entity)})).method_10852((class_2561)class_2561.method_43469((String)("letter.envelope.courier_death_notice.delivery." + delivery.getPhase().method_15434()), (Object[])new Object[]{delivery.getRecipient().format().withIcon().withIconColor(-4889793).withColor(-4889793).toComponent()})).method_10852((class_2561)(!delivery.getMail().method_7960() ? class_2561.method_43469((String)("letter.envelope.courier_death_notice.mail_lost_" + entity.method_59922().method_43048(6)), (Object[])new Object[]{delivery.getMail().method_7964().method_27661().method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_10949(new class_2568(class_2568.class_5247.field_24343, (Object)new class_2568.class_5249(delivery.getMail()))))}) : class_5244.field_39003)).method_10852((class_2561)class_2561.method_43469((String)("letter.envelope.courier_death_notice.condolence_" + entity.method_59922().method_43048(5)), (Object[])new Object[]{entity.method_5477()})).method_10852((class_2561)class_2561.method_43471((String)"letter.envelope.courier_death_notice.signature"));
        return ((MailBuilder)Mail.createLetter((class_2561)text).set(class_9334.field_49631, class_2561.method_43471((String)"letter.envelope.courier_death_notice.name"))).get();
    }
}

