/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.service;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.mail.address.Address;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_3218;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Players
extends class_18 {
    public static final Codec<Players> CODEC = Codec.unboundedMap((Codec)Codec.STRING, PlayerData.CODEC).xmap(Players::new, Players::getData);
    protected final Map<String, PlayerData> data;
    @Nullable
    protected Set<Address.Player> addresses;
    @Nullable
    protected Map<Address.Player, Address.Block> defaultAddresses;

    public Players(Map<String, PlayerData> data) {
        this.data = new HashMap<String, PlayerData>(data);
    }

    public Players() {
        this(Collections.emptyMap());
    }

    protected Map<String, PlayerData> getData() {
        return this.data;
    }

    public void add(class_1657 player) {
        this.data.computeIfAbsent(player.method_5820(), name -> new PlayerData(player.method_7334()));
        this.method_80();
    }

    public void remove(String name) {
        if (this.data.remove(name) != null) {
            this.method_80();
        }
    }

    public void clear() {
        this.data.clear();
        this.method_80();
    }

    public Optional<PlayerData> getDataOf(String playerName) {
        return Optional.ofNullable(this.data.get(playerName));
    }

    public Optional<Address.Block> getDefaultAddressOf(class_1657 player) {
        return this.getDataOf(player.method_5820()).flatMap(PlayerData::getDefaultAddress);
    }

    public Optional<Address.Block> getDefaultAddressOf(Address.Player playerAddress) {
        return this.getDataOf(playerAddress.toString()).flatMap(PlayerData::getDefaultAddress);
    }

    public void setDefaultAddress(class_1657 player, Address.Block address) {
        this.update(player, data -> data.setDefaultAddress(address));
    }

    public void renameDefaultAddress(Address.Block oldAddress, Address.Block newAddress) {
        this.getData().values().forEach(data -> {
            if (data.getDefaultAddress().map(a -> a.equals(oldAddress)).orElse(false).booleanValue()) {
                data.setDefaultAddress(newAddress);
            }
        });
        this.method_80();
    }

    public void removeDefaultAddress(Address.Block address) {
        this.getData().values().forEach(data -> {
            if (data.getDefaultAddress().map(a -> a.equals(address)).orElse(false).booleanValue()) {
                data.setDefaultAddress(null);
            }
        });
        this.method_80();
    }

    public void update(class_1657 player, Consumer<PlayerData> updater) {
        this.data.compute(player.method_5820(), (name, data) -> {
            if (data == null) {
                data = new PlayerData(player.method_7334());
            }
            updater.accept((PlayerData)data);
            return data;
        });
        this.method_80();
    }

    @NotNull
    public Set<Address.Player> getAllAddresses() {
        if (this.addresses == null) {
            this.addresses = this.data.keySet().stream().map(Address.Player::new).collect(Collectors.toSet());
        }
        return this.addresses;
    }

    public Map<Address.Player, Address.Block> getDefaultAddresses() {
        if (this.defaultAddresses == null) {
            this.defaultAddresses = new HashMap<Address.Player, Address.Block>();
            this.getData().forEach((name, data) -> data.getDefaultAddress().ifPresent(defaultAddress -> this.defaultAddresses.put(data.getAddress(), (Address.Block)defaultAddress)));
        }
        return this.defaultAddresses;
    }

    public void method_80() {
        super.method_80();
        this.resetCache();
    }

    protected void resetCache() {
        this.addresses = null;
        this.defaultAddresses = null;
    }

    public static Players get(class_3218 level, String name) {
        return (Players)level.method_17983().method_17924(Players.factory(), name);
    }

    @NotNull
    public class_2487 method_75(class_2487 tag, class_7225.class_7874 registries) {
        return CODEC.encode((Object)this, (DynamicOps)class_2509.field_11560, (Object)tag).ifError(e -> Envelope.LOGGER.error("Cannot save KnownPlayers: {}", (Object)e.message())).result().filter(t -> t instanceof class_2487).map(t -> (class_2487)t).orElse(tag);
    }

    private static Players load(class_2487 tag, class_7225.class_7874 registries) {
        return CODEC.decode((DynamicOps)class_2509.field_11560, (Object)tag).ifError(e -> Envelope.LOGGER.error("Cannot load KnownPlayers: {}", (Object)e.message())).result().map(Pair::getFirst).orElseGet(Players::new);
    }

    private static class_18.class_8645<Players> factory() {
        return new class_18.class_8645(Players::new, Players::load, null);
    }

    public static class PlayerData {
        public static final Codec<PlayerData> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_5699.field_45076.codec().fieldOf("profile").forGetter(PlayerData::getProfile), (App)Address.Block.STRING_CODEC.optionalFieldOf("default_address").forGetter(PlayerData::getDefaultAddress)).apply((Applicative)i, PlayerData::new));
        protected final GameProfile profile;
        protected final Address.Player address;
        protected Optional<Address.Block> defaultAddress;

        public PlayerData(GameProfile profile, Optional<Address.Block> defaultAddress) {
            this.profile = profile;
            this.address = new Address.Player(profile.getName());
            this.defaultAddress = defaultAddress;
        }

        public PlayerData(GameProfile profile) {
            this(profile, Optional.empty());
        }

        public GameProfile getProfile() {
            return this.profile;
        }

        public Address.Player getAddress() {
            return this.address;
        }

        public Optional<Address.Block> getDefaultAddress() {
            return this.defaultAddress;
        }

        public void setDefaultAddress(@Nullable Address.Block address) {
            this.defaultAddress = Optional.ofNullable(address);
        }
    }
}

