/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.util;

import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class AttributeUtils {
    public static ItemAttributeModifiers ArmorcreateAttributes(Holder<ArmorMaterial> material, ArmorItem.Type type, float attackDamage) {
        float knockback;
        float toughness;
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        EquipmentSlotGroup slotGroup = EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot());
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)("armor." + type.getName()));
        int defense = ((ArmorMaterial)material.value()).getDefense(type);
        if (defense > 0) {
            builder.add(Attributes.ARMOR, new AttributeModifier(id, (double)defense, AttributeModifier.Operation.ADD_VALUE), slotGroup);
        }
        if ((toughness = ((ArmorMaterial)material.value()).toughness()) > 0.0f) {
            builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(id, (double)toughness, AttributeModifier.Operation.ADD_VALUE), slotGroup);
        }
        if ((knockback = ((ArmorMaterial)material.value()).knockbackResistance()) > 0.0f) {
            builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(id, (double)knockback, AttributeModifier.Operation.ADD_VALUE), slotGroup);
        }
        if (attackDamage > 0.0f) {
            ResourceLocation attackId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)("armor.attack_damage." + type.getName()));
            builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(attackId, (double)attackDamage, AttributeModifier.Operation.ADD_VALUE), slotGroup);
        }
        return builder.build();
    }

    public static void mergeAttributes(DataComponentPatch.Builder builder, Item item, ItemAttributeModifiers newModifiers) {
        ItemAttributeModifiers existingModifiers = (ItemAttributeModifiers)item.components().getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        ItemAttributeModifiers.Builder combinedBuilder = ItemAttributeModifiers.builder();
        for (ItemAttributeModifiers.Entry existingEntry : existingModifiers.modifiers()) {
            boolean shouldReplace = false;
            for (ItemAttributeModifiers.Entry newEntry : newModifiers.modifiers()) {
                if (!existingEntry.attribute().equals((Object)newEntry.attribute()) || !existingEntry.slot().equals((Object)newEntry.slot())) continue;
                shouldReplace = true;
                break;
            }
            if (shouldReplace) continue;
            combinedBuilder.add(existingEntry.attribute(), existingEntry.modifier(), existingEntry.slot());
        }
        for (ItemAttributeModifiers.Entry newEntry : newModifiers.modifiers()) {
            combinedBuilder.add(newEntry.attribute(), newEntry.modifier(), newEntry.slot());
        }
        builder.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)combinedBuilder.build());
    }

    public static float OriginDamage(LivingEntity living, ItemStack itemStack) {
        double totalDamage = living.getAttributeValue(Attributes.ATTACK_DAMAGE);
        if (living.getMainHandItem() == itemStack) {
            return (float)totalDamage;
        }
        ItemStack mainHandStack = living.getMainHandItem();
        if (!mainHandStack.isEmpty()) {
            ItemAttributeModifiers modifiers = (ItemAttributeModifiers)mainHandStack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
            for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
                if (!entry.attribute().is(Attributes.ATTACK_DAMAGE) || !entry.slot().test(EquipmentSlot.MAINHAND) || entry.modifier().operation() != AttributeModifier.Operation.ADD_VALUE) continue;
                totalDamage -= entry.modifier().amount();
            }
        }
        ItemAttributeModifiers shredderModifiers = (ItemAttributeModifiers)itemStack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        for (ItemAttributeModifiers.Entry entry : shredderModifiers.modifiers()) {
            if (!entry.attribute().is(Attributes.ATTACK_DAMAGE) || !entry.slot().test(EquipmentSlot.MAINHAND) || entry.modifier().operation() != AttributeModifier.Operation.ADD_VALUE) continue;
            totalDamage += entry.modifier().amount();
        }
        return (float)totalDamage;
    }
}

