/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class AutoTitleGlobalData
extends SavedData {
    private static final String NAME = "mmorpgtitles_auto_titles";
    public static final Codec<AutoTitleGlobalData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)UUIDUtil.CODEC).optionalFieldOf("ClaimedUniqueRules", Map.of()).forGetter(data -> data.claimedUniqueRules)).apply((Applicative)instance, AutoTitleGlobalData::new));
    public static final SavedDataType<AutoTitleGlobalData> TYPE = new SavedDataType("mmorpgtitles_auto_titles", AutoTitleGlobalData::new, CODEC);
    private final Map<String, UUID> claimedUniqueRules;

    public AutoTitleGlobalData() {
        this(new HashMap<String, UUID>());
    }

    private AutoTitleGlobalData(Map<String, UUID> claimedUniqueRules) {
        this.claimedUniqueRules = new HashMap<String, UUID>(claimedUniqueRules);
    }

    public static AutoTitleGlobalData get(ServerLevel level) {
        return (AutoTitleGlobalData)level.getDataStorage().computeIfAbsent(TYPE);
    }

    public boolean isClaimed(String ruleId) {
        return this.claimedUniqueRules.containsKey(ruleId);
    }

    public UUID getClaimedBy(String ruleId) {
        return this.claimedUniqueRules.get(ruleId);
    }

    public boolean claim(String ruleId, UUID playerId) {
        if (this.claimedUniqueRules.containsKey(ruleId)) {
            return false;
        }
        this.claimedUniqueRules.put(ruleId, playerId);
        this.setDirty();
        return true;
    }

    public void unclaim(String ruleId) {
        if (this.claimedUniqueRules.remove(ruleId) != null) {
            this.setDirty();
        }
    }
}

