/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import com.fen.mmorpgtitles.AutoTitleCondition;
import com.fen.mmorpgtitles.AutoTitleConfig;
import com.fen.mmorpgtitles.AutoTitleGlobalData;
import com.fen.mmorpgtitles.AutoTitleProgress;
import com.fen.mmorpgtitles.AutoTitleRule;
import com.fen.mmorpgtitles.AutoTitleRuleMode;
import com.fen.mmorpgtitles.TitleData;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.storage.LevelResource;

public class AutoTitleManager {
    private static final String CONFIG_NAME = "mmorpgtitles_auto_titles.json";
    private static AutoTitleConfig config;
    private static Path configPath;
    private static MinecraftServer cachedServer;
    private static final Map<UUID, Identifier> LAST_BIOME;
    private static final Map<UUID, Identifier> LAST_STRUCTURE;

    private static AutoTitleConfig getConfig(MinecraftServer server) {
        AutoTitleManager.ensureLoaded(server);
        return config;
    }

    private static Path getConfigPath(MinecraftServer server) {
        Path root = server.getWorldPath(LevelResource.ROOT);
        return root.resolve("serverconfig").resolve(CONFIG_NAME);
    }

    private static void ensureLoaded(MinecraftServer server) {
        if (server == null) {
            return;
        }
        if (config != null && cachedServer == server) {
            return;
        }
        cachedServer = server;
        configPath = AutoTitleManager.getConfigPath(server);
        config = AutoTitleConfig.load(configPath);
        AutoTitleManager.normalizeConfig(config);
    }

    public static void reload(MinecraftServer server) {
        cachedServer = server;
        configPath = AutoTitleManager.getConfigPath(server);
        config = AutoTitleConfig.load(configPath);
        AutoTitleManager.normalizeConfig(config);
    }

    public static void save(MinecraftServer server) {
        if (config == null || server == null) {
            return;
        }
        AutoTitleConfig.save(AutoTitleManager.getConfigPath(server), config);
    }

    private static AutoTitleGlobalData getGlobalData(MinecraftServer server) {
        if (server == null) {
            return null;
        }
        ServerLevel level = server.getLevel(Level.OVERWORLD);
        if (level == null) {
            return null;
        }
        return AutoTitleGlobalData.get(level);
    }

    public static List<AutoTitleRule> getRules(MinecraftServer server) {
        return new ArrayList<AutoTitleRule>(AutoTitleManager.getConfig((MinecraftServer)server).rules);
    }

    public static AutoTitleRule getRule(MinecraftServer server, String ruleId) {
        if (ruleId == null) {
            return null;
        }
        for (AutoTitleRule rule : AutoTitleManager.getConfig((MinecraftServer)server).rules) {
            if (rule == null || !ruleId.equalsIgnoreCase(rule.id)) continue;
            return rule;
        }
        return null;
    }

    public static boolean removeRule(MinecraftServer server, String ruleId) {
        if (ruleId == null) {
            return false;
        }
        AutoTitleConfig cfg = AutoTitleManager.getConfig(server);
        boolean removed = cfg.rules.removeIf(rule -> rule != null && ruleId.equalsIgnoreCase(rule.id));
        if (removed) {
            ServerLevel level = server.getLevel(Level.OVERWORLD);
            if (level != null) {
                AutoTitleGlobalData.get(level).unclaim(ruleId);
            }
            AutoTitleManager.save(server);
        }
        return removed;
    }

    public static String addRule(MinecraftServer server, AutoTitleRule rule) {
        AutoTitleConfig cfg = AutoTitleManager.getConfig(server);
        rule.normalizeDefaults();
        AutoTitleManager.normalizeRuleText(rule);
        if (rule.conditions != null) {
            for (AutoTitleCondition condition : rule.conditions) {
                AutoTitleManager.normalizeCondition(condition);
            }
        }
        if (rule.title == null || rule.title.isBlank()) {
            return null;
        }
        if (rule.conditions == null || rule.conditions.isEmpty()) {
            return null;
        }
        if (rule.id == null || rule.id.isBlank()) {
            rule.id = AutoTitleManager.generateId(rule.title, AutoTitleManager.collectRuleIds(cfg));
        }
        if (AutoTitleManager.hasRuleId(cfg, rule.id) || AutoTitleManager.hasRuleTitle(cfg, rule.title)) {
            return null;
        }
        cfg.rules.add(rule);
        AutoTitleManager.save(server);
        return rule.id;
    }

    public static boolean isChatMessageEnabled(MinecraftServer server) {
        return AutoTitleManager.getConfig((MinecraftServer)server).chatMessageOnAutoGrant;
    }

    public static void onKillPlayer(ServerPlayer killer, ItemStack weapon) {
        MinecraftServer server = killer.level().getServer();
        if (server == null) {
            return;
        }
        Identifier weaponId = weapon == null || weapon.isEmpty() ? null : BuiltInRegistries.ITEM.getKey((Object)weapon.getItem());
        AutoTitleGlobalData global = AutoTitleManager.getGlobalData(server);
        if (global == null) {
            return;
        }
        for (AutoTitleRule rule : AutoTitleManager.getConfig((MinecraftServer)server).rules) {
            if (!AutoTitleManager.isRuleActive(rule, global, killer)) continue;
            boolean updated = false;
            for (int i = 0; i < rule.conditions.size(); ++i) {
                AutoTitleCondition condition = rule.conditions.get(i);
                if (!"kill_players".equalsIgnoreCase(condition.type) || (condition.item != null && weaponId != null ? !AutoTitleManager.normalizeId(condition.item).equals(weaponId.toString()) : condition.item != null)) continue;
                int current = AutoTitleProgress.getProgress(killer, rule.id, i);
                int next = Math.min(current + 1, Math.max(1, condition.count));
                AutoTitleProgress.setProgress(killer, rule.id, i, next);
                updated = true;
            }
            if (!updated) continue;
            AutoTitleManager.checkAndGrant(killer, rule, global, server);
        }
    }

    public static void onBlockBroken(ServerPlayer player, Block block) {
        MinecraftServer server = player.level().getServer();
        if (server == null || block == null) {
            return;
        }
        Identifier blockId = BuiltInRegistries.BLOCK.getKey((Object)block);
        AutoTitleGlobalData global = AutoTitleManager.getGlobalData(server);
        if (global == null) {
            return;
        }
        for (AutoTitleRule rule : AutoTitleManager.getConfig((MinecraftServer)server).rules) {
            if (!AutoTitleManager.isRuleActive(rule, global, player)) continue;
            boolean updated = false;
            for (int i = 0; i < rule.conditions.size(); ++i) {
                AutoTitleCondition condition = rule.conditions.get(i);
                if (!"break_block".equalsIgnoreCase(condition.type) || condition.block == null || blockId == null || !AutoTitleManager.normalizeId(condition.block).equals(blockId.toString())) continue;
                int current = AutoTitleProgress.getProgress(player, rule.id, i);
                int next = Math.min(current + 1, Math.max(1, condition.count));
                AutoTitleProgress.setProgress(player, rule.id, i, next);
                updated = true;
            }
            if (!updated) continue;
            AutoTitleManager.checkAndGrant(player, rule, global, server);
        }
    }

    public static void onKillMob(ServerPlayer killer, Entity victim, ItemStack weapon) {
        MinecraftServer server = killer.level().getServer();
        if (server == null || victim == null) {
            return;
        }
        Identifier entityId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)victim.getType());
        Identifier weaponId = weapon == null || weapon.isEmpty() ? null : BuiltInRegistries.ITEM.getKey((Object)weapon.getItem());
        AutoTitleGlobalData global = AutoTitleManager.getGlobalData(server);
        if (global == null) {
            return;
        }
        for (AutoTitleRule rule : AutoTitleManager.getConfig((MinecraftServer)server).rules) {
            if (!AutoTitleManager.isRuleActive(rule, global, killer)) continue;
            boolean updated = false;
            for (int i = 0; i < rule.conditions.size(); ++i) {
                AutoTitleCondition condition = rule.conditions.get(i);
                if (!"kill_mob".equalsIgnoreCase(condition.type) || condition.entity == null || entityId == null || !AutoTitleManager.normalizeId(condition.entity).equals(entityId.toString()) || (condition.item != null && weaponId != null ? !AutoTitleManager.normalizeId(condition.item).equals(weaponId.toString()) : condition.item != null)) continue;
                int current = AutoTitleProgress.getProgress(killer, rule.id, i);
                int next = Math.min(current + 1, Math.max(1, condition.count));
                AutoTitleProgress.setProgress(killer, rule.id, i, next);
                updated = true;
            }
            if (!updated) continue;
            AutoTitleManager.checkAndGrant(killer, rule, global, server);
        }
    }

    public static void onDimensionVisited(ServerPlayer player, Identifier dimensionId) {
        if (dimensionId == null) {
            return;
        }
        MinecraftServer server = player.level().getServer();
        if (server == null) {
            return;
        }
        String dimId = dimensionId.toString();
        AutoTitleGlobalData global = AutoTitleManager.getGlobalData(server);
        if (global == null) {
            return;
        }
        for (AutoTitleRule rule : AutoTitleManager.getConfig((MinecraftServer)server).rules) {
            if (!AutoTitleManager.isRuleActive(rule, global, player)) continue;
            boolean updated = false;
            for (int i = 0; i < rule.conditions.size(); ++i) {
                AutoTitleCondition condition = rule.conditions.get(i);
                if (!"visit_dimension".equalsIgnoreCase(condition.type) || condition.dimension == null || !AutoTitleManager.normalizeId(condition.dimension).equals(dimId) || AutoTitleProgress.getProgress(player, rule.id, i) >= 1) continue;
                AutoTitleProgress.setProgress(player, rule.id, i, 1);
                updated = true;
            }
            if (!updated) continue;
            AutoTitleManager.checkAndGrant(player, rule, global, server);
        }
    }

    public static void onBiomeVisited(ServerPlayer player, Identifier biomeId) {
        if (biomeId == null) {
            return;
        }
        MinecraftServer server = player.level().getServer();
        if (server == null) {
            return;
        }
        String id = biomeId.toString();
        AutoTitleGlobalData global = AutoTitleManager.getGlobalData(server);
        if (global == null) {
            return;
        }
        for (AutoTitleRule rule : AutoTitleManager.getConfig((MinecraftServer)server).rules) {
            if (!AutoTitleManager.isRuleActive(rule, global, player)) continue;
            boolean updated = false;
            for (int i = 0; i < rule.conditions.size(); ++i) {
                AutoTitleCondition condition = rule.conditions.get(i);
                if (!"visit_biome".equalsIgnoreCase(condition.type) || condition.biome == null || !AutoTitleManager.normalizeId(condition.biome).equals(id) || AutoTitleProgress.getProgress(player, rule.id, i) >= 1) continue;
                AutoTitleProgress.setProgress(player, rule.id, i, 1);
                updated = true;
            }
            if (!updated) continue;
            AutoTitleManager.checkAndGrant(player, rule, global, server);
        }
    }

    public static void onStructureVisited(ServerPlayer player, Identifier structureId) {
        if (structureId == null) {
            return;
        }
        MinecraftServer server = player.level().getServer();
        if (server == null) {
            return;
        }
        String id = structureId.toString();
        AutoTitleGlobalData global = AutoTitleManager.getGlobalData(server);
        if (global == null) {
            return;
        }
        for (AutoTitleRule rule : AutoTitleManager.getConfig((MinecraftServer)server).rules) {
            if (!AutoTitleManager.isRuleActive(rule, global, player)) continue;
            boolean updated = false;
            for (int i = 0; i < rule.conditions.size(); ++i) {
                AutoTitleCondition condition = rule.conditions.get(i);
                if (!"visit_structure".equalsIgnoreCase(condition.type) || condition.structure == null || !AutoTitleManager.normalizeId(condition.structure).equals(id) || AutoTitleProgress.getProgress(player, rule.id, i) >= 1) continue;
                AutoTitleProgress.setProgress(player, rule.id, i, 1);
                updated = true;
            }
            if (!updated) continue;
            AutoTitleManager.checkAndGrant(player, rule, global, server);
        }
    }

    public static void onLevelChanged(ServerPlayer player, int newLevel) {
        MinecraftServer server = player.level().getServer();
        if (server == null) {
            return;
        }
        AutoTitleGlobalData global = AutoTitleManager.getGlobalData(server);
        if (global == null) {
            return;
        }
        for (AutoTitleRule rule : AutoTitleManager.getConfig((MinecraftServer)server).rules) {
            if (!AutoTitleManager.isRuleActive(rule, global, player)) continue;
            boolean updated = false;
            for (int i = 0; i < rule.conditions.size(); ++i) {
                int current;
                AutoTitleCondition condition = rule.conditions.get(i);
                if (!"reach_level".equalsIgnoreCase(condition.type) || newLevel <= (current = AutoTitleProgress.getProgress(player, rule.id, i))) continue;
                AutoTitleProgress.setProgress(player, rule.id, i, newLevel);
                updated = true;
            }
            if (!updated) continue;
            AutoTitleManager.checkAndGrant(player, rule, global, server);
        }
    }

    public static void onPlayerDeath(ServerPlayer player) {
        MinecraftServer server = player.level().getServer();
        if (server == null) {
            return;
        }
        AutoTitleGlobalData global = AutoTitleManager.getGlobalData(server);
        if (global == null) {
            return;
        }
        for (AutoTitleRule rule : AutoTitleManager.getConfig((MinecraftServer)server).rules) {
            if (!AutoTitleManager.isRuleActive(rule, global, player)) continue;
            boolean updated = false;
            for (int i = 0; i < rule.conditions.size(); ++i) {
                AutoTitleCondition condition = rule.conditions.get(i);
                if (!"deaths".equalsIgnoreCase(condition.type)) continue;
                int current = AutoTitleProgress.getProgress(player, rule.id, i);
                int next = Math.min(current + 1, Math.max(1, condition.count));
                AutoTitleProgress.setProgress(player, rule.id, i, next);
                updated = true;
            }
            if (!updated) continue;
            AutoTitleManager.checkAndGrant(player, rule, global, server);
        }
    }

    public static void onFishCaught(ServerPlayer player, int count) {
        if (count <= 0) {
            return;
        }
        MinecraftServer server = player.level().getServer();
        if (server == null) {
            return;
        }
        AutoTitleGlobalData global = AutoTitleManager.getGlobalData(server);
        if (global == null) {
            return;
        }
        for (AutoTitleRule rule : AutoTitleManager.getConfig((MinecraftServer)server).rules) {
            if (!AutoTitleManager.isRuleActive(rule, global, player)) continue;
            boolean updated = false;
            for (int i = 0; i < rule.conditions.size(); ++i) {
                AutoTitleCondition condition = rule.conditions.get(i);
                if (!"fish".equalsIgnoreCase(condition.type)) continue;
                int current = AutoTitleProgress.getProgress(player, rule.id, i);
                int next = Math.min(current + count, Math.max(1, condition.count));
                AutoTitleProgress.setProgress(player, rule.id, i, next);
                updated = true;
            }
            if (!updated) continue;
            AutoTitleManager.checkAndGrant(player, rule, global, server);
        }
    }

    public static void onPlayerTick(ServerPlayer player) {
        Identifier last;
        MinecraftServer server = player.level().getServer();
        if (server == null || player.tickCount % 20 != 0) {
            return;
        }
        Holder biomeHolder = player.level().getBiome(player.blockPosition());
        Identifier biomeId = biomeHolder.unwrapKey().map(key -> key.identifier()).orElse(null);
        if (!(biomeId == null || (last = LAST_BIOME.put(player.getUUID(), biomeId)) != null && last.equals((Object)biomeId))) {
            AutoTitleManager.onBiomeVisited(player, biomeId);
        }
        Identifier structureId = AutoTitleManager.getStructureId(player);
        Identifier lastStructure = LAST_STRUCTURE.put(player.getUUID(), structureId);
        if (!(structureId == null || lastStructure != null && structureId.equals((Object)lastStructure))) {
            AutoTitleManager.onStructureVisited(player, structureId);
        }
    }

    private static Identifier getStructureId(ServerPlayer player) {
        ServerLevel serverLevel = player.level();
        if (!(serverLevel instanceof ServerLevel)) {
            return null;
        }
        ServerLevel level = serverLevel;
        StructureManager manager = level.structureManager();
        StructureStart start = manager.getStructureWithPieceAt(player.blockPosition(), holder -> true);
        if (start == null || !start.isValid()) {
            return null;
        }
        Structure structure = start.getStructure();
        if (structure == null) {
            return null;
        }
        return level.registryAccess().lookupOrThrow(Registries.STRUCTURE).getKey((Object)structure);
    }

    private static void checkAndGrant(ServerPlayer player, AutoTitleRule rule, AutoTitleGlobalData global, MinecraftServer server) {
        boolean completed;
        if (rule == null || rule.conditions == null || rule.conditions.isEmpty()) {
            return;
        }
        AutoTitleRuleMode mode = rule.getMode();
        boolean anyMet = false;
        for (int i = 0; i < rule.conditions.size(); ++i) {
            AutoTitleCondition condition = rule.conditions.get(i);
            if (condition == null) continue;
            boolean met = AutoTitleManager.isConditionMet(player, rule, condition, i);
            if (met) {
                anyMet = true;
                if (mode != AutoTitleRuleMode.ANY_OF) continue;
                break;
            }
            if (mode != AutoTitleRuleMode.ALL_OF) continue;
            return;
        }
        boolean bl = completed = mode == AutoTitleRuleMode.ANY_OF ? anyMet : true;
        if (!completed) {
            return;
        }
        if (rule.unique && !global.claim(rule.id, player.getUUID())) {
            return;
        }
        boolean granted = TitleData.grant(player, rule.title, rule.description);
        if (!granted) {
            return;
        }
        AutoTitleProgress.setCompleted(player, rule.id);
        AutoTitleManager.playTitleSound(player, rule.unique);
        if (AutoTitleManager.isChatMessageEnabled(server)) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.rtitle.autogrant", (Object[])new Object[]{rule.title}));
        }
    }

    private static boolean isConditionMet(ServerPlayer player, AutoTitleRule rule, AutoTitleCondition condition, int index) {
        String type;
        int progress = AutoTitleProgress.getProgress(player, rule.id, index);
        switch (type = condition.type == null ? "" : condition.type.toLowerCase(Locale.ROOT)) {
            case "kill_players": 
            case "kill_mob": 
            case "break_block": 
            case "deaths": 
            case "fish": {
                return progress >= Math.max(1, condition.count);
            }
            case "visit_dimension": 
            case "visit_biome": 
            case "visit_structure": {
                return progress >= 1;
            }
            case "reach_level": {
                return progress >= Math.max(1, condition.level);
            }
        }
        return false;
    }

    private static boolean isRuleActive(AutoTitleRule rule, AutoTitleGlobalData global, ServerPlayer player) {
        if (rule == null) {
            return false;
        }
        rule.normalizeDefaults();
        if (rule.id == null || rule.id.isBlank()) {
            return false;
        }
        if (rule.title == null || rule.title.isBlank()) {
            return false;
        }
        if (rule.conditions == null || rule.conditions.isEmpty()) {
            return false;
        }
        if (AutoTitleProgress.isCompleted(player, rule.id)) {
            return false;
        }
        if (TitleData.has(player, rule.title)) {
            return false;
        }
        return !rule.unique || global == null || !global.isClaimed(rule.id);
    }

    private static void normalizeConfig(AutoTitleConfig cfg) {
        if (cfg == null) {
            return;
        }
        cfg.normalize();
        HashSet<String> seenIds = new HashSet<String>();
        for (AutoTitleRule rule : cfg.rules) {
            if (rule == null) continue;
            AutoTitleManager.normalizeRuleText(rule);
            if (rule.id == null || rule.id.isBlank()) {
                rule.id = AutoTitleManager.generateId(rule.title, seenIds);
            }
            seenIds.add(rule.id.toLowerCase(Locale.ROOT));
            if (rule.conditions == null) continue;
            for (AutoTitleCondition condition : rule.conditions) {
                AutoTitleManager.normalizeCondition(condition);
            }
        }
    }

    private static void normalizeRuleText(AutoTitleRule rule) {
        if (rule.title != null) {
            rule.title = AutoTitleManager.normalizeText(rule.title);
        }
        if (rule.description != null) {
            rule.description = AutoTitleManager.normalizeText(rule.description);
        }
    }

    private static void normalizeCondition(AutoTitleCondition condition) {
        if (condition == null) {
            return;
        }
        if (condition.item != null) {
            condition.item = AutoTitleManager.normalizeId(condition.item);
        }
        if (condition.block != null) {
            condition.block = AutoTitleManager.normalizeId(condition.block);
        }
        if (condition.dimension != null) {
            condition.dimension = AutoTitleManager.normalizeId(condition.dimension);
        }
        if (condition.biome != null) {
            condition.biome = AutoTitleManager.normalizeId(condition.biome);
        }
        if (condition.structure != null) {
            condition.structure = AutoTitleManager.normalizeId(condition.structure);
        }
        if (condition.entity != null) {
            condition.entity = AutoTitleManager.normalizeId(condition.entity);
        }
    }

    private static String normalizeId(String raw) {
        return raw == null ? "" : raw.trim().toLowerCase(Locale.ROOT);
    }

    private static String normalizeText(String raw) {
        if (raw == null) {
            return "";
        }
        return raw.trim().replaceAll("\\s{2,}", " ");
    }

    private static boolean hasRuleId(AutoTitleConfig cfg, String id) {
        for (AutoTitleRule rule : cfg.rules) {
            if (rule == null || !id.equalsIgnoreCase(rule.id)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasRuleTitle(AutoTitleConfig cfg, String title) {
        for (AutoTitleRule rule : cfg.rules) {
            if (rule == null || !title.equalsIgnoreCase(rule.title)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> collectRuleIds(AutoTitleConfig cfg) {
        HashSet<String> ids = new HashSet<String>();
        for (AutoTitleRule rule : cfg.rules) {
            if (rule == null || rule.id == null) continue;
            ids.add(rule.id.toLowerCase(Locale.ROOT));
        }
        return ids;
    }

    private static String generateId(String title, Set<String> existingIds) {
        String base;
        String string = base = title == null ? "" : title.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9]+", "_").replaceAll("_+", "_").replaceAll("^_|_$", "");
        if (base.isBlank()) {
            base = "title";
        }
        Object id = base;
        int suffix = 2;
        while (existingIds.contains(((String)id).toLowerCase(Locale.ROOT))) {
            id = base + "_" + suffix;
            ++suffix;
        }
        return id;
    }

    public static void playTitleSound(ServerPlayer player, boolean unique) {
        if (player == null) {
            return;
        }
        player.connection.send((Packet)new ClientboundSoundPacket(BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)(unique ? SoundEvents.UI_TOAST_CHALLENGE_COMPLETE : SoundEvents.PLAYER_LEVELUP)), SoundSource.PLAYERS, player.getX(), player.getY(), player.getZ(), 1.0f, 1.0f, player.level().getRandom().nextLong()));
    }

    static {
        LAST_BIOME = new HashMap<UUID, Identifier>();
        LAST_STRUCTURE = new HashMap<UUID, Identifier>();
    }
}

