/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;

public class AutoTitleProgress {
    private static final String ROOT = "mmorpgtitles";
    private static final String KEY_PROGRESS = "AutoTitleProgress";
    private static final String KEY_DONE = "Done";

    private static CompoundTag getRoot(ServerPlayer player) {
        CompoundTag data = player.getPersistentData();
        return data.getCompound(ROOT).orElseGet(() -> {
            CompoundTag root = new CompoundTag();
            data.put(ROOT, (Tag)root);
            return root;
        });
    }

    private static CompoundTag getProgressRoot(ServerPlayer player) {
        CompoundTag root = AutoTitleProgress.getRoot(player);
        CompoundTag progress = root.getCompound(KEY_PROGRESS).orElse(null);
        if (progress == null) {
            progress = new CompoundTag();
            root.put(KEY_PROGRESS, (Tag)progress);
        }
        return progress;
    }

    private static CompoundTag getRuleTag(ServerPlayer player, String ruleId) {
        CompoundTag progress = AutoTitleProgress.getProgressRoot(player);
        CompoundTag rule = progress.getCompound(ruleId).orElse(null);
        if (rule == null) {
            rule = new CompoundTag();
            progress.put(ruleId, (Tag)rule);
        }
        return rule;
    }

    public static int getProgress(ServerPlayer player, String ruleId, int index) {
        CompoundTag rule = AutoTitleProgress.getRuleTag(player, ruleId);
        return rule.getIntOr("c" + index, 0);
    }

    public static void setProgress(ServerPlayer player, String ruleId, int index, int value) {
        CompoundTag rule = AutoTitleProgress.getRuleTag(player, ruleId);
        rule.putInt("c" + index, value);
    }

    public static boolean isCompleted(ServerPlayer player, String ruleId) {
        CompoundTag rule = AutoTitleProgress.getRuleTag(player, ruleId);
        return rule.getBooleanOr(KEY_DONE, false);
    }

    public static void setCompleted(ServerPlayer player, String ruleId) {
        CompoundTag rule = AutoTitleProgress.getRuleTag(player, ruleId);
        rule.putBoolean(KEY_DONE, true);
    }
}

