/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class ChatFormatData
extends SavedData {
    private static final String NAME = "mmorpgtitles_chat_format";
    private static final String KEY_FORMAT = "Format";
    private static final String DEFAULT_FORMAT = "[{title}] <{player}>: {message}";
    public static final Codec<ChatFormatData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf(KEY_FORMAT, (Object)DEFAULT_FORMAT).forGetter(data -> data.format)).apply((Applicative)instance, ChatFormatData::new));
    public static final SavedDataType<ChatFormatData> TYPE = new SavedDataType("mmorpgtitles_chat_format", ChatFormatData::new, CODEC);
    private String format = "[{title}] <{player}>: {message}";

    public ChatFormatData() {
        this(DEFAULT_FORMAT);
    }

    private ChatFormatData(String format) {
        this.format = format;
    }

    public static ChatFormatData get(ServerLevel level) {
        return (ChatFormatData)level.getDataStorage().computeIfAbsent(TYPE);
    }

    public String getFormat() {
        return this.format == null || this.format.isBlank() ? DEFAULT_FORMAT : this.format;
    }

    public void setFormat(String format) {
        this.format = format == null ? "" : format;
        this.setDirty();
    }
}

