/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import com.fen.mmorpgtitles.TitleData;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;

public final class ChatFormatter {
    private ChatFormatter() {
    }

    public static MutableComponent build(String format, ServerPlayer player, Component message) {
        String titleDesc;
        if (format == null || format.isBlank()) {
            format = "[{title}] <{player}>: {message}";
        }
        MutableComponent out = Component.literal((String)"");
        String title = TitleData.getDisplayed(player);
        String string = titleDesc = title == null || title.isBlank() ? "" : TitleData.getDescription(player, title);
        if (title == null || title.isBlank()) {
            format = format.replace("[{title}]", "").replace("{title}", "");
            format = format.replaceAll("\\s{2,}", " ").trim();
        }
        int i = 0;
        while (i < format.length()) {
            if (format.startsWith("{title}", i)) {
                if (title != null && !title.isBlank()) {
                    String formattedTitle = "\u00a7r" + title.replace('&', '\u00a7');
                    MutableComponent titleComp = Component.literal((String)formattedTitle);
                    if (titleDesc != null && !titleDesc.isBlank()) {
                        titleComp = titleComp.withStyle(style -> style.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)titleDesc))));
                    }
                    out.append((Component)titleComp);
                }
                i += "{title}".length();
                continue;
            }
            if (format.startsWith("{player}", i)) {
                out.append((Component)Component.literal((String)player.getName().getString()));
                i += "{player}".length();
                continue;
            }
            if (format.startsWith("{message}", i)) {
                out.append(message);
                i += "{message}".length();
                continue;
            }
            out.append((Component)Component.literal((String)String.valueOf(format.charAt(i))));
            ++i;
        }
        return out;
    }
}

