/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;

public class TitleData {
    private static final String ROOT = "mmorpgtitles";
    private static final String KEY_GRANTED = "GrantedTitles";
    private static final String KEY_DISPLAYED = "DisplayedTitle";
    private static final String TAG_TITLE = "Title";
    private static final String TAG_DESC = "Description";

    private static CompoundTag getRoot(ServerPlayer player) {
        CompoundTag data = player.getPersistentData();
        return data.getCompound(ROOT).orElseGet(() -> {
            CompoundTag root = new CompoundTag();
            data.put(ROOT, (Tag)root);
            return root;
        });
    }

    private static String normalize(String s) {
        if (s == null) {
            return "";
        }
        return s.trim().replaceAll("\\s{2,}", " ");
    }

    public static boolean grant(ServerPlayer player, String title, String description) {
        title = TitleData.normalize(title);
        description = TitleData.normalize(description);
        if (title.isEmpty()) {
            return false;
        }
        CompoundTag root = TitleData.getRoot(player);
        ListTag list = root.getListOrEmpty(KEY_GRANTED);
        for (Tag t : list) {
            CompoundTag ct = (CompoundTag)t;
            if (!ct.getStringOr(TAG_TITLE, "").equalsIgnoreCase(title)) continue;
            return false;
        }
        CompoundTag entry = new CompoundTag();
        entry.putString(TAG_TITLE, title);
        entry.putString(TAG_DESC, description);
        list.add((Object)entry);
        root.put(KEY_GRANTED, (Tag)list);
        return true;
    }

    public static boolean revoke(ServerPlayer player, String title) {
        if ((title = TitleData.normalize(title)).isEmpty()) {
            return false;
        }
        CompoundTag root = TitleData.getRoot(player);
        ListTag list = root.getListOrEmpty(KEY_GRANTED);
        boolean removed = false;
        ListTag newList = new ListTag();
        for (Tag t : list) {
            CompoundTag ct = (CompoundTag)t;
            String existing = ct.getStringOr(TAG_TITLE, "");
            if (existing.equalsIgnoreCase(title)) {
                removed = true;
                continue;
            }
            newList.add((Object)ct);
        }
        if (!removed) {
            return false;
        }
        root.put(KEY_GRANTED, (Tag)newList);
        String displayed = TitleData.getDisplayed(player);
        if (displayed != null && displayed.equalsIgnoreCase(title)) {
            TitleData.setDisplayed(player, "");
        }
        return true;
    }

    public static boolean has(ServerPlayer player, String title) {
        title = TitleData.normalize(title);
        ListTag list = TitleData.getRoot(player).getListOrEmpty(KEY_GRANTED);
        for (Tag t : list) {
            if (!((CompoundTag)t).getStringOr(TAG_TITLE, "").equalsIgnoreCase(title)) continue;
            return true;
        }
        return false;
    }

    public static String getDescription(ServerPlayer player, String title) {
        title = TitleData.normalize(title);
        ListTag list = TitleData.getRoot(player).getListOrEmpty(KEY_GRANTED);
        for (Tag t : list) {
            CompoundTag ct = (CompoundTag)t;
            if (!ct.getStringOr(TAG_TITLE, "").equalsIgnoreCase(title)) continue;
            return ct.getStringOr(TAG_DESC, "");
        }
        return "";
    }

    public static List<String> getGrantedTitles(ServerPlayer player) {
        ListTag list = TitleData.getRoot(player).getListOrEmpty(KEY_GRANTED);
        ArrayList<String> out = new ArrayList<String>();
        for (Tag t : list) {
            out.add(((CompoundTag)t).getStringOr(TAG_TITLE, ""));
        }
        out.sort(String.CASE_INSENSITIVE_ORDER);
        return out;
    }

    public static void setDisplayed(ServerPlayer player, String title) {
        TitleData.getRoot(player).putString(KEY_DISPLAYED, TitleData.normalize(title));
    }

    public static String getDisplayed(ServerPlayer player) {
        return TitleData.getRoot(player).getStringOr(KEY_DISPLAYED, "");
    }
}

