/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import com.fen.mmorpgtitles.TitleData;
import com.fen.mmorpgtitles.TitleSystem;
import com.fen.mmorpgtitles.network.NetworkHandler;
import com.fen.mmorpgtitles.network.TitlePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class TitleEvents {
    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer joining = (ServerPlayer)player;
        for (ServerPlayer p : joining.level().getServer().getPlayerList().getPlayers()) {
            String displayed = TitleData.getDisplayed(p);
            if (displayed == null || displayed.isBlank()) continue;
            NetworkHandler.sendToPlayer(joining, new TitlePacket(p.getUUID(), displayed.replace('&', '\u00a7'), false));
        }
        String selfTitle = TitleData.getDisplayed(joining);
        if (selfTitle != null && !selfTitle.isBlank()) {
            NetworkHandler.sendToAll(joining.level().getServer(), new TitlePacket(joining.getUUID(), selfTitle.replace('&', '\u00a7'), false));
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        TitleSystem.restoreDisplayedTitle(player2);
        String displayed = TitleData.getDisplayed(player2);
        if (displayed != null && !displayed.isBlank()) {
            NetworkHandler.sendToAll(player2.level().getServer(), new TitlePacket(player2.getUUID(), displayed.replace('&', '\u00a7'), false));
        }
    }
}

