/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import com.fen.mmorpgtitles.TitleSystem;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderNameTagEvent;

public class TitleManager {
    @SubscribeEvent
    public void onRenderNameTag(RenderNameTagEvent.DoRender event) {
        EntityRenderState renderState = event.getEntityRenderState();
        if (!(renderState instanceof AvatarRenderState)) {
            return;
        }
        AvatarRenderState avatarState = (AvatarRenderState)renderState;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        Entity entity = mc.level.getEntity(avatarState.id);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Component title = TitleSystem.getPlayerTitle(player);
        if (title == null || title.getString().isBlank()) {
            return;
        }
        Vec3 attachment = renderState.nameTagAttachment;
        if (attachment == null) {
            attachment = player.getAttachments().getNullable(EntityAttachment.NAME_TAG, 0, player.getYRot(event.getPartialTick()));
        }
        if (attachment == null) {
            return;
        }
        Objects.requireNonNull(mc.font);
        int yOffset = -9 - 1;
        event.getSubmitNodeCollector().submitNameTag(event.getPoseStack(), attachment, yOffset, title, !renderState.isDiscrete, renderState.lightCoords, renderState.distanceToCameraSq, event.getCameraRenderState());
    }
}

