/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles.network;

import com.fen.mmorpgtitles.network.TitlePacket;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;

public final class NetworkHandler {
    private NetworkHandler() {
    }

    public static void register(RegisterPayloadHandlersEvent event) {
        event.registrar("1").playToClient(TitlePacket.TYPE, TitlePacket.STREAM_CODEC, TitlePacket::handleClient);
        System.out.println("[mmorpgtitles] Payloads registered.");
    }

    public static void sendToPlayer(ServerPlayer player, TitlePacket payload) {
        if (player == null) {
            return;
        }
        player.connection.send((Packet)new ClientboundCustomPayloadPacket((CustomPacketPayload)payload));
    }

    public static void sendToAll(MinecraftServer server, TitlePacket payload) {
        if (server == null) {
            return;
        }
        PlayerList list = server.getPlayerList();
        for (ServerPlayer p : list.getPlayers()) {
            NetworkHandler.sendToPlayer(p, payload);
        }
    }

    public static void sendToAll(Level level, TitlePacket payload) {
        if (level == null || level.isClientSide()) {
            return;
        }
        NetworkHandler.sendToAll(level.getServer(), payload);
    }
}

