/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles.network;

import com.fen.mmorpgtitles.TitleSystem;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record TitlePacket(UUID playerUUID, String title, boolean remove) implements CustomPacketPayload
{
    public static final Identifier ID = Identifier.fromNamespaceAndPath((String)"mmorpgtitles", (String)"title");
    public static final CustomPacketPayload.Type<TitlePacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, TitlePacket> STREAM_CODEC = StreamCodec.of((buf, pkt) -> {
        buf.writeUUID(pkt.playerUUID);
        buf.writeBoolean(pkt.remove);
        if (!pkt.remove) {
            buf.writeUtf(pkt.title);
        }
    }, buf -> {
        UUID uuid = buf.readUUID();
        boolean remove = buf.readBoolean();
        String title = remove ? "" : buf.readUtf();
        return new TitlePacket(uuid, title, remove);
    });

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleClient(TitlePacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null || mc.level == null) {
                return;
            }
            for (Player p : mc.level.players()) {
                if (!p.getUUID().equals(packet.playerUUID)) continue;
                if (packet.remove) {
                    TitleSystem.removePlayerTitle(p);
                    break;
                }
                TitleSystem.setPlayerTitle(p, packet.title);
                break;
            }
        });
    }
}

