/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import com.fen.mmorpgtitles.AutoTitleManager;
import com.fen.mmorpgtitles.TitleSystem;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class AutoTitleEvents {
    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        ServerPlayer sp;
        ServerPlayer victim;
        LivingEntity livingEntity = event.getEntity();
        ServerPlayer serverPlayer = victim = livingEntity instanceof ServerPlayer ? (sp = (ServerPlayer)livingEntity) : null;
        if (victim != null) {
            AutoTitleManager.onPlayerDeath(victim);
            TitleSystem.saveTitleBeforeDeath(victim);
        }
        if ((livingEntity = event.getSource().getEntity()) instanceof ServerPlayer) {
            ServerPlayer killer = (ServerPlayer)livingEntity;
            if (victim != null) {
                if (killer != victim) {
                    AutoTitleManager.onKillPlayer(killer, killer.getMainHandItem());
                }
            } else {
                AutoTitleManager.onKillMob(killer, (Entity)event.getEntity(), killer.getMainHandItem());
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        AutoTitleManager.onBlockBroken(player2, event.getState().getBlock());
    }

    @SubscribeEvent
    public void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        AutoTitleManager.onDimensionVisited(player2, event.getTo().location());
    }

    @SubscribeEvent
    public void onPlayerLevelChange(PlayerXpEvent.LevelChange event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        AutoTitleManager.onLevelChanged(player2, player2.experienceLevel);
    }

    @SubscribeEvent
    public void onItemFished(ItemFishedEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        NonNullList drops = event.getDrops();
        if (drops == null || drops.isEmpty()) {
            return;
        }
        int fishCount = 0;
        for (ItemStack stack : drops) {
            if (stack.isEmpty() || !stack.is(ItemTags.FISHES)) continue;
            fishCount += stack.getCount();
        }
        if (fishCount > 0) {
            AutoTitleManager.onFishCaught(player2, fishCount);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        AutoTitleManager.onPlayerTick(player2);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer respawned = (ServerPlayer)player;
        TitleSystem.restoreDisplayedTitle(respawned);
    }
}

