/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import com.fen.mmorpgtitles.AutoTitleCondition;
import com.fen.mmorpgtitles.AutoTitleGlobalData;
import com.fen.mmorpgtitles.AutoTitleManager;
import com.fen.mmorpgtitles.AutoTitleRule;
import com.fen.mmorpgtitles.ChatFormatData;
import com.fen.mmorpgtitles.TitleConfigData;
import com.fen.mmorpgtitles.TitleData;
import com.fen.mmorpgtitles.TitleExportImport;
import com.fen.mmorpgtitles.TitleSystem;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ModCommands {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_SELF_TITLES = (ctx, builder) -> {
        Entity patt0$temp = ((CommandSourceStack)ctx.getSource()).getEntity();
        if (!(patt0$temp instanceof ServerPlayer)) {
            return builder.buildFuture();
        }
        ServerPlayer sp = (ServerPlayer)patt0$temp;
        return SharedSuggestionProvider.suggest(TitleData.getGrantedTitles(sp), (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_TARGET_TITLES = (ctx, builder) -> {
        try {
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            return SharedSuggestionProvider.suggest(TitleData.getGrantedTitles(target), (SuggestionsBuilder)builder);
        }
        catch (Exception e) {
            return builder.buildFuture();
        }
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_RULE_IDS = (ctx, builder) -> {
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        List<AutoTitleRule> rules = AutoTitleManager.getRules(server);
        ArrayList<String> ids = new ArrayList<String>();
        for (AutoTitleRule rule : rules) {
            if (rule == null || rule.id == null || rule.id.isBlank()) continue;
            ids.add(rule.id);
        }
        return SharedSuggestionProvider.suggest(ids, (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_DIMENSIONS = (ctx, builder) -> {
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        return SharedSuggestionProvider.suggestResource(server.levelKeys().stream().map(key -> key.location()).toList(), (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_BIOMES = (ctx, builder) -> SharedSuggestionProvider.suggestResource((Iterable)((CommandSourceStack)ctx.getSource()).registryAccess().registryOrThrow(Registries.BIOME).keySet(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_STRUCTURES = (ctx, builder) -> SharedSuggestionProvider.suggestResource((Iterable)((CommandSourceStack)ctx.getSource()).registryAccess().registryOrThrow(Registries.STRUCTURE).keySet(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_ENTITIES = (ctx, builder) -> SharedSuggestionProvider.suggestResource((Iterable)((CommandSourceStack)ctx.getSource()).registryAccess().registryOrThrow(Registries.ENTITY_TYPE).keySet(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"rtitle").then(((LiteralArgumentBuilder)Commands.literal((String)"grant").requires(s -> s.hasPermission(2))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"title", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String title;
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            if (!TitleData.grant(target, title = StringArgumentType.getString((CommandContext)ctx, (String)"title"), "")) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.rtitle.grant.already"));
                return 0;
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.rtitle.grant.success"), true);
            AutoTitleManager.playTitleSound(target, false);
            return 1;
        })).then(Commands.literal((String)"desc").then(Commands.argument((String)"description", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String desc;
            String title;
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            if (!TitleData.grant(target, title = StringArgumentType.getString((CommandContext)ctx, (String)"title"), desc = StringArgumentType.getString((CommandContext)ctx, (String)"description"))) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.rtitle.grant.already"));
                return 0;
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.rtitle.grant.success.desc"), true);
            AutoTitleManager.playTitleSound(target, false);
            return 1;
        }))))))).then(ModCommands.buildAddRuleCommand(context))).then(ModCommands.buildRulesCommand())).then(((LiteralArgumentBuilder)Commands.literal((String)"revoke").requires(s -> s.hasPermission(2))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"title", (ArgumentType)StringArgumentType.greedyString()).suggests(SUGGEST_TARGET_TITLES).executes(ctx -> {
            String title;
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            if (!TitleData.revoke(target, title = StringArgumentType.getString((CommandContext)ctx, (String)"title"))) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.rtitle.revoke.fail"));
                return 0;
            }
            String displayed = TitleData.getDisplayed(target);
            if (displayed == null || displayed.isBlank()) {
                TitleSystem.removePlayerTitle((Player)target);
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.rtitle.revoke.success"), true);
            return 1;
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(s -> s.hasPermission(2))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"title", (ArgumentType)StringArgumentType.greedyString()).suggests(SUGGEST_TARGET_TITLES).executes(ctx -> {
            String title;
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            if (!TitleData.has(target, title = StringArgumentType.getString((CommandContext)ctx, (String)"title"))) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.rtitle.set.fail"));
                return 0;
            }
            TitleData.setDisplayed(target, title);
            TitleSystem.setPlayerTitle((Player)target, title);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.rtitle.set.success"), true);
            return 1;
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"refresh").requires(s -> s.hasPermission(2))).executes(ctx -> {
            MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
            for (ServerPlayer sp : server.getPlayerList().getPlayers()) {
                TitleSystem.restoreDisplayedTitle(sp);
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.rtitle.refresh.success"), true);
            return 1;
        }))).then(Commands.literal((String)"display").then(Commands.argument((String)"title", (ArgumentType)StringArgumentType.greedyString()).suggests(SUGGEST_SELF_TITLES).executes(ctx -> {
            Entity patt0$temp = ((CommandSourceStack)ctx.getSource()).getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return 0;
            }
            ServerPlayer sp = (ServerPlayer)patt0$temp;
            String title = StringArgumentType.getString((CommandContext)ctx, (String)"title");
            if (!TitleData.has(sp, title)) {
                sp.sendSystemMessage((Component)Component.translatable((String)"command.rtitle.display.fail"));
                return 0;
            }
            TitleData.setDisplayed(sp, title);
            TitleSystem.setPlayerTitle((Player)sp, title);
            sp.sendSystemMessage((Component)Component.translatable((String)"command.rtitle.display.success"));
            return 1;
        })))).then(Commands.literal((String)"hide").executes(ctx -> {
            Entity patt0$temp = ((CommandSourceStack)ctx.getSource()).getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return 0;
            }
            ServerPlayer sp = (ServerPlayer)patt0$temp;
            TitleData.setDisplayed(sp, "");
            TitleSystem.removePlayerTitle((Player)sp);
            sp.sendSystemMessage((Component)Component.translatable((String)"command.rtitle.hide"));
            return 1;
        }))).then(Commands.literal((String)"list").executes(ctx -> {
            Entity patt0$temp = ((CommandSourceStack)ctx.getSource()).getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return 0;
            }
            ServerPlayer sp = (ServerPlayer)patt0$temp;
            List<String> titles = TitleData.getGrantedTitles(sp);
            if (titles.isEmpty()) {
                sp.sendSystemMessage((Component)Component.translatable((String)"command.rtitle.list.empty"));
            } else {
                sp.sendSystemMessage((Component)Component.translatable((String)"command.rtitle.list", (Object[])new Object[]{titles.toString()}));
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"export").requires(s -> s.hasPermission(2))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            Entity patt0$temp = ((CommandSourceStack)ctx.getSource()).getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return 0;
            }
            ServerPlayer sp = (ServerPlayer)patt0$temp;
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
            if (TitleExportImport.exportTitles(sp, name, server)) {
                String dirPath = TitleExportImport.getTitlesDirectoryPath();
                String fileName = name.replaceAll("[<>:\"/\\|?*]", "_").replaceAll("\\s+", "_").replaceAll("_{2,}", "_") + ".json";
                sp.sendSystemMessage((Component)Component.translatable((String)"command.rtitle.export.success", (Object[])new Object[]{fileName}).append((Component)Component.literal((String)("\u00a7n\u00a7e" + fileName)).withStyle(s -> s.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, dirPath)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"command.rtitle.export.hover"))))));
                return 1;
            }
            sp.sendSystemMessage((Component)Component.translatable((String)"command.rtitle.export.fail"));
            return 0;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"import").requires(s -> s.hasPermission(2))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            List<String> files = TitleExportImport.getAvailableFiles();
            return SharedSuggestionProvider.suggest(files, (SuggestionsBuilder)builder);
        }).executes(ctx -> {
            Entity patt0$temp = ((CommandSourceStack)ctx.getSource()).getEntity();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return 0;
            }
            ServerPlayer sp = (ServerPlayer)patt0$temp;
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
            if (TitleExportImport.importTitles(sp, name, server)) {
                sp.sendSystemMessage((Component)Component.translatable((String)"command.rtitle.import.success", (Object[])new Object[]{name}));
                return 1;
            }
            sp.sendSystemMessage((Component)Component.translatable((String)"command.rtitle.import.fail"));
            return 0;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"chatprefix").requires(s -> s.hasPermission(2))).then(Commands.literal((String)"on").executes(ctx -> {
            ServerPlayer sp = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            TitleConfigData.get(sp.serverLevel()).setChatPrefixEnabled(true);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.rtitle.chatprefix.on"), true);
            return 1;
        }))).then(Commands.literal((String)"off").executes(ctx -> {
            ServerPlayer sp = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            TitleConfigData.get(sp.serverLevel()).setChatPrefixEnabled(false);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.rtitle.chatprefix.off"), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"chatformat").requires(s -> s.hasPermission(2))).executes(ctx -> {
            ServerPlayer sp = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String current = ChatFormatData.get(sp.serverLevel()).getFormat();
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.rtitle.chatformat.current", (Object[])new Object[]{current}), false);
            return 1;
        })).then(Commands.argument((String)"format", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            ServerPlayer sp = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String format = StringArgumentType.getString((CommandContext)ctx, (String)"format");
            ChatFormatData.get(sp.serverLevel()).setFormat(format);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.rtitle.chatformat.updated"), true);
            return 1;
        }))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildAddRuleCommand(CommandBuildContext context) {
        LiteralArgumentBuilder add = (LiteralArgumentBuilder)Commands.literal((String)"add").requires(s -> s.hasPermission(2));
        RequiredArgumentBuilder titleArg = Commands.argument((String)"title", (ArgumentType)StringArgumentType.string());
        RequiredArgumentBuilder descArg = Commands.argument((String)"description", (ArgumentType)StringArgumentType.string());
        ModCommands.addConditionBranches(descArg, context);
        titleArg.then(Commands.literal((String)"desc").then((ArgumentBuilder)descArg));
        ModCommands.addConditionBranches(titleArg, context);
        add.then((ArgumentBuilder)titleArg);
        return add;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildRulesCommand() {
        LiteralArgumentBuilder rules = (LiteralArgumentBuilder)Commands.literal((String)"rules").requires(s -> s.hasPermission(2));
        rules.then(Commands.literal((String)"list").executes(ModCommands::executeListRules));
        rules.then(Commands.literal((String)"reload").executes(ctx -> {
            AutoTitleManager.reload(((CommandSourceStack)ctx.getSource()).getServer());
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.rtitle.rule.reload"), true);
            return 1;
        }));
        rules.then(Commands.literal((String)"remove").then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_RULE_IDS).executes(ModCommands::executeRemoveRule)));
        return rules;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> addConditionBranches(ArgumentBuilder<CommandSourceStack, ?> root, CommandBuildContext context) {
        ModCommands.addKillBranch(root, "kill_player", context);
        ModCommands.addKillBranch(root, "kill", context);
        ModCommands.addKillMobBranch(root, context);
        root.then(Commands.literal((String)"break_block").then(Commands.argument((String)"block", (ArgumentType)BlockStateArgument.block((CommandBuildContext)context)).then(((RequiredArgumentBuilder)Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            String blockId = BuiltInRegistries.BLOCK.getKey((Object)BlockStateArgument.getBlock((CommandContext)ctx, (String)"block").getState().getBlock()).toString();
            return ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.breakBlock(blockId, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count")), false);
        })).then(Commands.literal((String)"unique").executes(ctx -> {
            String blockId = BuiltInRegistries.BLOCK.getKey((Object)BlockStateArgument.getBlock((CommandContext)ctx, (String)"block").getState().getBlock()).toString();
            return ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.breakBlock(blockId, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count")), true);
        })))));
        root.then(Commands.literal((String)"visit_dimension").then(((RequiredArgumentBuilder)Commands.argument((String)"dimension", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_DIMENSIONS).executes(ctx -> ModCommands.executeAddDimensionRule((CommandContext<CommandSourceStack>)ctx, false))).then(Commands.literal((String)"unique").executes(ctx -> ModCommands.executeAddDimensionRule((CommandContext<CommandSourceStack>)ctx, true)))));
        root.then(Commands.literal((String)"visit_biome").then(((RequiredArgumentBuilder)Commands.argument((String)"biome", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_BIOMES).executes(ctx -> ModCommands.executeAddBiomeRule((CommandContext<CommandSourceStack>)ctx, false))).then(Commands.literal((String)"unique").executes(ctx -> ModCommands.executeAddBiomeRule((CommandContext<CommandSourceStack>)ctx, true)))));
        root.then(Commands.literal((String)"visit_structure").then(((RequiredArgumentBuilder)Commands.argument((String)"structure", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_STRUCTURES).executes(ctx -> ModCommands.executeAddStructureRule((CommandContext<CommandSourceStack>)ctx, false))).then(Commands.literal((String)"unique").executes(ctx -> ModCommands.executeAddStructureRule((CommandContext<CommandSourceStack>)ctx, true)))));
        root.then(Commands.literal((String)"reach_level").then(((RequiredArgumentBuilder)Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.reachLevel(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level")), false))).then(Commands.literal((String)"unique").executes(ctx -> ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.reachLevel(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level")), true)))));
        root.then(Commands.literal((String)"deaths").then(((RequiredArgumentBuilder)Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.deaths(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count")), false))).then(Commands.literal((String)"unique").executes(ctx -> ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.deaths(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count")), true)))));
        root.then(Commands.literal((String)"fish").then(((RequiredArgumentBuilder)Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.fish(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count")), false))).then(Commands.literal((String)"unique").executes(ctx -> ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.fish(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count")), true)))));
        return root;
    }

    private static void addKillBranch(ArgumentBuilder<CommandSourceStack, ?> root, String literal, CommandBuildContext context) {
        root.then(Commands.literal((String)literal).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.killPlayers(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), null), false))).then(Commands.literal((String)"unique").executes(ctx -> ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.killPlayers(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), null), true)))).then(Commands.literal((String)"item").then(((RequiredArgumentBuilder)Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)context)).executes(ctx -> {
            String itemId = BuiltInRegistries.ITEM.getKey((Object)ItemArgument.getItem((CommandContext)ctx, (String)"item").getItem()).toString();
            return ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.killPlayers(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), itemId), false);
        })).then(Commands.literal((String)"unique").executes(ctx -> {
            String itemId = BuiltInRegistries.ITEM.getKey((Object)ItemArgument.getItem((CommandContext)ctx, (String)"item").getItem()).toString();
            return ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.killPlayers(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), itemId), true);
        }))))));
    }

    private static void addKillMobBranch(ArgumentBuilder<CommandSourceStack, ?> root, CommandBuildContext context) {
        root.then(Commands.literal((String)"kill_mob").then(Commands.argument((String)"mob", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_ENTITIES).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ModCommands.executeAddMobRule((CommandContext<CommandSourceStack>)ctx, false, null))).then(Commands.literal((String)"unique").executes(ctx -> ModCommands.executeAddMobRule((CommandContext<CommandSourceStack>)ctx, true, null)))).then(Commands.literal((String)"item").then(((RequiredArgumentBuilder)Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)context)).executes(ctx -> {
            String itemId = BuiltInRegistries.ITEM.getKey((Object)ItemArgument.getItem((CommandContext)ctx, (String)"item").getItem()).toString();
            return ModCommands.executeAddMobRule((CommandContext<CommandSourceStack>)ctx, false, itemId);
        })).then(Commands.literal((String)"unique").executes(ctx -> {
            String itemId = BuiltInRegistries.ITEM.getKey((Object)ItemArgument.getItem((CommandContext)ctx, (String)"item").getItem()).toString();
            return ModCommands.executeAddMobRule((CommandContext<CommandSourceStack>)ctx, true, itemId);
        })))))));
    }

    private static int executeAddRule(CommandContext<CommandSourceStack> ctx, AutoTitleCondition condition, boolean unique) {
        if (condition == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.rtitle.rule.add.fail"));
            return 0;
        }
        String title = StringArgumentType.getString(ctx, (String)"title");
        String description = "";
        try {
            description = StringArgumentType.getString(ctx, (String)"description");
        }
        catch (Exception ignored) {
            description = "";
        }
        AutoTitleRule rule = new AutoTitleRule();
        rule.title = title;
        rule.description = description;
        rule.unique = unique;
        rule.mode = "all_of";
        rule.conditions = new ArrayList<AutoTitleCondition>();
        rule.conditions.add(condition);
        String id = AutoTitleManager.addRule(((CommandSourceStack)ctx.getSource()).getServer(), rule);
        if (id == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.rtitle.rule.add.fail"));
            return 0;
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.rtitle.rule.add.success", (Object[])new Object[]{id}), true);
        return 1;
    }

    private static int executeAddDimensionRule(CommandContext<CommandSourceStack> ctx, boolean unique) {
        ResourceLocation id = ResourceLocationArgument.getId(ctx, (String)"dimension");
        boolean exists = ((CommandSourceStack)ctx.getSource()).getServer().levelKeys().stream().anyMatch(key -> key.location().equals((Object)id));
        if (!exists) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.rtitle.rule.invalid_dimension", (Object[])new Object[]{id.toString()}));
            return 0;
        }
        return ModCommands.executeAddRule(ctx, AutoTitleCondition.visitDimension(id.toString()), unique);
    }

    private static int executeAddBiomeRule(CommandContext<CommandSourceStack> ctx, boolean unique) {
        ResourceLocation id = ResourceLocationArgument.getId(ctx, (String)"biome");
        boolean exists = ((CommandSourceStack)ctx.getSource()).registryAccess().registryOrThrow(Registries.BIOME).containsKey(id);
        if (!exists) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.rtitle.rule.invalid_biome", (Object[])new Object[]{id.toString()}));
            return 0;
        }
        return ModCommands.executeAddRule(ctx, AutoTitleCondition.visitBiome(id.toString()), unique);
    }

    private static int executeAddStructureRule(CommandContext<CommandSourceStack> ctx, boolean unique) {
        ResourceLocation id = ResourceLocationArgument.getId(ctx, (String)"structure");
        boolean exists = ((CommandSourceStack)ctx.getSource()).registryAccess().registryOrThrow(Registries.STRUCTURE).containsKey(id);
        if (!exists) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.rtitle.rule.invalid_structure", (Object[])new Object[]{id.toString()}));
            return 0;
        }
        return ModCommands.executeAddRule(ctx, AutoTitleCondition.visitStructure(id.toString()), unique);
    }

    private static int executeAddMobRule(CommandContext<CommandSourceStack> ctx, boolean unique, String itemId) {
        ResourceLocation id = ResourceLocationArgument.getId(ctx, (String)"mob");
        boolean exists = ((CommandSourceStack)ctx.getSource()).registryAccess().registryOrThrow(Registries.ENTITY_TYPE).containsKey(id);
        if (!exists) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.rtitle.rule.invalid_entity", (Object[])new Object[]{id.toString()}));
            return 0;
        }
        int count = IntegerArgumentType.getInteger(ctx, (String)"count");
        return ModCommands.executeAddRule(ctx, AutoTitleCondition.killMob(id.toString(), count, itemId), unique);
    }

    private static int executeRemoveRule(CommandContext<CommandSourceStack> ctx) {
        String id = StringArgumentType.getString(ctx, (String)"id");
        boolean removed = AutoTitleManager.removeRule(((CommandSourceStack)ctx.getSource()).getServer(), id);
        if (!removed) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.rtitle.rule.remove.fail"));
            return 0;
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.rtitle.rule.remove.success"), true);
        return 1;
    }

    private static int executeListRules(CommandContext<CommandSourceStack> ctx) {
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        List<AutoTitleRule> rules = AutoTitleManager.getRules(server);
        if (rules.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.rtitle.rule.list.empty"), false);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.rtitle.rule.list.header"), false);
        AutoTitleGlobalData global = null;
        if (server.getLevel(Level.OVERWORLD) != null) {
            global = AutoTitleGlobalData.get(server.getLevel(Level.OVERWORLD));
        }
        for (AutoTitleRule rule : rules) {
            if (rule == null) continue;
            boolean claimed = rule.unique && global != null && global.isClaimed(rule.id);
            String line = String.format("[%s] %s (unique=%s, mode=%s, conditions=%d%s)", rule.id, rule.title, rule.unique, rule.mode, rule.conditions == null ? 0 : rule.conditions.size(), claimed ? ", claimed" : "");
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)line), false);
        }
        return 1;
    }
}

