/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class TitleConfigData
extends SavedData {
    private static final String NAME = "mmorpgtitles_config";
    private boolean chatPrefixEnabled = false;

    public static TitleConfigData get(ServerLevel level) {
        return (TitleConfigData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(TitleConfigData::new, TitleConfigData::load), NAME);
    }

    public boolean isChatPrefixEnabled() {
        return this.chatPrefixEnabled;
    }

    public void setChatPrefixEnabled(boolean enabled) {
        this.chatPrefixEnabled = enabled;
        this.setDirty();
    }

    public static TitleConfigData load(CompoundTag tag, HolderLookup.Provider lookup) {
        TitleConfigData data = new TitleConfigData();
        data.chatPrefixEnabled = tag.getBoolean("ChatPrefixEnabled");
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider lookup) {
        tag.putBoolean("ChatPrefixEnabled", this.chatPrefixEnabled);
        return tag;
    }
}

