/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import com.fen.mmorpgtitles.TitleData;
import com.fen.mmorpgtitles.TitleSystem;
import com.fen.mmorpgtitles.network.NetworkHandler;
import com.fen.mmorpgtitles.network.TitlePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class TitleEvents {
    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer joining = (ServerPlayer)player;
        TitleSystem.restoreDisplayedTitle(joining);
        for (ServerPlayer p : joining.server.getPlayerList().getPlayers()) {
            String displayed;
            if (p == joining || (displayed = TitleData.getDisplayed(p)) == null || displayed.isBlank()) continue;
            NetworkHandler.sendToPlayer(joining, new TitlePacket(p.getUUID(), displayed.replace('&', '\u00a7'), false));
        }
        String joinersDisplayed = TitleData.getDisplayed(joining);
        if (joinersDisplayed != null && !joinersDisplayed.isBlank()) {
            for (ServerPlayer p : joining.server.getPlayerList().getPlayers()) {
                if (p == joining) continue;
                NetworkHandler.sendToPlayer(p, new TitlePacket(joining.getUUID(), joinersDisplayed.replace('&', '\u00a7'), false));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        Entity target = event.getTarget();
        if (!(target instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer trackedPlayer = (ServerPlayer)target;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer observer = (ServerPlayer)player;
        String displayed = TitleData.getDisplayed(trackedPlayer);
        if (displayed != null && !displayed.isBlank()) {
            NetworkHandler.sendToPlayer(observer, new TitlePacket(trackedPlayer.getUUID(), displayed.replace('&', '\u00a7'), false));
        }
    }
}

