/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import com.fen.mmorpgtitles.TitleSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;

public class TitleManager {
    private static final float NAME_TAG_SCALE = 0.025f;
    private static final float BASE_Y_OFFSET = 0.6f;
    private static final float TITLE_Y_OFFSET = -10.0f;

    @SubscribeEvent
    public void onRenderLiving(RenderLivingEvent.Post<?, ?> event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Component title = TitleSystem.getPlayerTitle(player);
        if (title == null || title.getString().isBlank()) {
            return;
        }
        if (!TitleManager.shouldRenderTitle(player)) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        EntityRenderDispatcher dispatcher = mc.getEntityRenderDispatcher();
        Font font = mc.font;
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource buffers = event.getMultiBufferSource();
        poseStack.pushPose();
        poseStack.translate(0.0, (double)(player.getBbHeight() + 0.6f), 0.0);
        poseStack.mulPose(dispatcher.cameraOrientation());
        poseStack.scale(-0.025f, -0.025f, 0.025f);
        float xOffset = (float)(-font.width((FormattedText)title)) / 2.0f;
        float yOffset = TitleManager.getNameTagYOffset(player.getDisplayName()) + -10.0f;
        boolean seeThrough = !player.isDiscrete();
        float backgroundOpacity = mc.options.getBackgroundOpacity(0.25f);
        int backgroundColor = (int)(backgroundOpacity * 255.0f) << 24;
        int textColor = 0xFFFFFF;
        font.drawInBatch(title, xOffset, yOffset, textColor, false, poseStack.last().pose(), buffers, seeThrough ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, backgroundColor, event.getPackedLight());
        if (seeThrough) {
            font.drawInBatch(title, xOffset, yOffset, textColor, false, poseStack.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, event.getPackedLight());
        }
        poseStack.popPose();
    }

    private static float getNameTagYOffset(Component nameTag) {
        if (nameTag != null && "deadmau5".equals(nameTag.getString())) {
            return -10.0f;
        }
        return 0.0f;
    }

    private static boolean shouldRenderTitle(Player player) {
        boolean visibleToLocal;
        float maxDistance;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer localPlayer = mc.player;
        if (localPlayer == null) {
            return false;
        }
        double distanceSqr = mc.getEntityRenderDispatcher().distanceToSqr((Entity)player);
        float f = maxDistance = player.isDiscrete() ? 32.0f : 64.0f;
        if (distanceSqr >= (double)(maxDistance * maxDistance)) {
            return false;
        }
        boolean bl = visibleToLocal = !player.isInvisibleTo((Player)localPlayer);
        if (player != localPlayer) {
            PlayerTeam team = player.getTeam();
            PlayerTeam localTeam = localPlayer.getTeam();
            if (team != null) {
                Team.Visibility visibility = team.getNameTagVisibility();
                switch (visibility) {
                    case ALWAYS: {
                        return visibleToLocal;
                    }
                    case NEVER: {
                        return false;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        return localTeam == null ? visibleToLocal : team.isAlliedTo((Team)localTeam) && (team.canSeeFriendlyInvisibles() || visibleToLocal);
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        return localTeam == null ? visibleToLocal : !team.isAlliedTo((Team)localTeam) && visibleToLocal;
                    }
                }
                return true;
            }
        }
        return Minecraft.renderNames() && player != mc.getCameraEntity() && visibleToLocal && !player.isVehicle();
    }
}

