/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import com.fen.mmorpgtitles.TitleData;
import com.fen.mmorpgtitles.network.NetworkHandler;
import com.fen.mmorpgtitles.network.TitlePacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class TitleSystem {
    private static final Map<UUID, Component> playerTitles = new HashMap<UUID, Component>();

    public static void setPlayerTitle(Player player, String titleText) {
        if (player == null) {
            return;
        }
        if (titleText == null || titleText.isBlank()) {
            TitleSystem.removePlayerTitle(player);
            return;
        }
        String formatted = titleText.replace('&', '\u00a7');
        MutableComponent component = Component.literal((String)formatted);
        playerTitles.put(player.getUUID(), (Component)component);
        if (!player.level().isClientSide() && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            NetworkHandler.sendToAll(sp.server, new TitlePacket(sp.getUUID(), formatted, false));
        }
    }

    public static void removePlayerTitle(Player player) {
        if (player == null) {
            return;
        }
        playerTitles.remove(player.getUUID());
        if (!player.level().isClientSide() && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            NetworkHandler.sendToAll(sp.server, new TitlePacket(sp.getUUID(), "", true));
        }
    }

    public static Component getPlayerTitle(Player player) {
        if (player == null) {
            return null;
        }
        return playerTitles.get(player.getUUID());
    }

    public static void clearAll() {
        playerTitles.clear();
    }

    public static void saveTitleBeforeDeath(ServerPlayer player) {
        if (player == null) {
            return;
        }
        Component comp = playerTitles.get(player.getUUID());
        if (comp == null) {
            return;
        }
        String raw = comp.getString().replace('\u00a7', '&');
        TitleData.setDisplayed(player, raw);
    }

    public static void restoreDisplayedTitle(ServerPlayer player) {
        String displayed = TitleData.getDisplayed(player);
        if (displayed != null && !displayed.isBlank()) {
            TitleSystem.setPlayerTitle((Player)player, displayed);
        }
    }
}

