/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles.network;

import com.fen.mmorpgtitles.TitleSystem;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record TitlePacket(UUID playerUUID, String title, boolean remove) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"mmorpgtitles", (String)"title");
    public static final CustomPacketPayload.Type<TitlePacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, TitlePacket> STREAM_CODEC = StreamCodec.of((buf, pkt) -> {
        buf.writeUUID(pkt.playerUUID);
        buf.writeBoolean(pkt.remove);
        if (!pkt.remove) {
            buf.writeUtf(pkt.title);
        }
    }, buf -> {
        UUID uuid = buf.readUUID();
        boolean remove = buf.readBoolean();
        String title = remove ? "" : buf.readUtf();
        return new TitlePacket(uuid, title, remove);
    });

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleClient(TitlePacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> TitlePacket.handleClient(packet));
    }

    private static void handleClient(TitlePacket packet) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft == null || minecraft.level == null) {
            System.out.println("Title packet received before client level was ready.");
            return;
        }
        Player direct = minecraft.level.getPlayerByUUID(packet.playerUUID);
        if (direct != null) {
            if (packet.remove) {
                TitleSystem.removePlayerTitle(direct);
            } else {
                TitleSystem.setPlayerTitle(direct, packet.title);
            }
            String action = packet.remove ? "remove" : packet.title;
            System.out.println("Applied title packet for " + direct.getName().getString() + ": " + action);
            return;
        }
        for (Entity entity : minecraft.level.entitiesForRendering()) {
            Player player;
            if (!(entity instanceof Player) || !(player = (Player)entity).getUUID().equals(packet.playerUUID)) continue;
            if (packet.remove) {
                TitleSystem.removePlayerTitle(player);
            } else {
                TitleSystem.setPlayerTitle(player, packet.title);
            }
            String action = packet.remove ? "remove" : packet.title;
            System.out.println("Applied title packet for " + player.getName().getString() + ": " + action);
            return;
        }
        System.out.println("Player not found for title packet: " + String.valueOf(packet.playerUUID));
    }
}

