/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import com.fen.mmorpgtitles.AutoTitleRule;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public class AutoTitleConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public boolean chatMessageOnAutoGrant = true;
    public List<AutoTitleRule> rules = new ArrayList<AutoTitleRule>();

    public void normalize() {
        if (this.rules == null) {
            this.rules = new ArrayList<AutoTitleRule>();
        }
        for (AutoTitleRule rule : this.rules) {
            if (rule == null) continue;
            rule.normalizeDefaults();
        }
    }

    public static AutoTitleConfig load(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            AutoTitleConfig config = new AutoTitleConfig();
            AutoTitleConfig.save(path, config);
            return config;
        }
        try {
            String raw = Files.readString(path, StandardCharsets.UTF_8);
            String json = AutoTitleConfig.stripComments(raw);
            if (json.isBlank()) {
                AutoTitleConfig config = new AutoTitleConfig();
                AutoTitleConfig.save(path, config);
                return config;
            }
            AutoTitleConfig config = (AutoTitleConfig)GSON.fromJson(json, AutoTitleConfig.class);
            if (config == null) {
                config = new AutoTitleConfig();
            }
            config.normalize();
            return config;
        }
        catch (Exception e) {
            System.out.println("[mmorpgtitles] Failed to load auto title config: " + e.getMessage());
            AutoTitleConfig config = new AutoTitleConfig();
            AutoTitleConfig.save(path, config);
            return config;
        }
    }

    public static void save(Path path, AutoTitleConfig config) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            String header = AutoTitleConfig.defaultHeader();
            String json = GSON.toJson((Object)config);
            String out = header + json + System.lineSeparator();
            Files.writeString(path, (CharSequence)out, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            System.out.println("[mmorpgtitles] Failed to save auto title config: " + e.getMessage());
        }
    }

    private static String stripComments(String raw) {
        String[] lines;
        StringBuilder out = new StringBuilder();
        for (String line : lines = raw.split("\\R", -1)) {
            String trimmed = line.trim();
            if (trimmed.startsWith("#") || trimmed.startsWith("//")) continue;
            out.append(line).append(System.lineSeparator());
        }
        return out.toString();
    }

    private static String defaultHeader() {
        return String.join((CharSequence)System.lineSeparator(), "# mmorpgtitles auto title rules", "#", "# chatMessageOnAutoGrant: true/false", "# rules: list of rule objects", "#", "# Rule fields:", "# - id: unique string (generated when using commands)", "# - title: title text (supports color codes with &)", "# - description: optional text", "# - unique: true/false (true = only first player can get it)", "# - mode: all_of | any_of", "# - conditions: list of condition objects", "#", "# Condition types and fields:", "# - kill_players: count (int), item (item id, optional)", "# - kill_mob: entity (entity id), count (int), item (item id, optional)", "# - break_block: block (block id), count (int)", "# - visit_dimension: dimension (dimension id)", "# - visit_biome: biome (biome id)", "# - visit_structure: structure (structure id)", "# - reach_level: level (int)", "# - deaths: count (int)", "# - fish: count (int)", "#", "# Example:", "# {", "#   \"chatMessageOnAutoGrant\": true,", "#   \"rules\": [", "#     {", "#       \"id\": \"first_blood\",", "#       \"title\": \"First Blood\",", "#       \"description\": \"Kill 5 players\",", "#       \"unique\": false,", "#       \"mode\": \"all_of\",", "#       \"conditions\": [", "#         { \"type\": \"kill_players\", \"count\": 5, \"item\": \"minecraft:diamond_sword\" }", "#       ]", "#     }", "#   ]", "# }", "") + System.lineSeparator();
    }
}

