/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import com.fen.mmorpgtitles.AutoTitleManager;
import com.fen.mmorpgtitles.TitleSystem;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mmorpgtitles", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AutoTitleEvents {
    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        ServerPlayer sp;
        ServerPlayer victim;
        LivingEntity livingEntity = event.getEntity();
        ServerPlayer serverPlayer = victim = livingEntity instanceof ServerPlayer ? (sp = (ServerPlayer)livingEntity) : null;
        if (victim != null) {
            AutoTitleManager.onPlayerDeath(victim);
            TitleSystem.saveTitleBeforeDeath(victim);
        }
        if ((livingEntity = event.getSource().m_7639_()) instanceof ServerPlayer) {
            ServerPlayer killer = (ServerPlayer)livingEntity;
            if (victim != null) {
                if (killer != victim) {
                    AutoTitleManager.onKillPlayer(killer, killer.m_21205_());
                }
            } else {
                AutoTitleManager.onKillMob(killer, (Entity)event.getEntity(), killer.m_21205_());
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        AutoTitleManager.onBlockBroken(player2, event.getState().m_60734_());
    }

    @SubscribeEvent
    public void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        AutoTitleManager.onDimensionVisited(player2, event.getTo().m_135782_());
    }

    @SubscribeEvent
    public void onPlayerLevelChange(PlayerXpEvent.LevelChange event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        AutoTitleManager.onLevelChanged(player2, player2.f_36078_);
    }

    @SubscribeEvent
    public void onItemFished(ItemFishedEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        NonNullList drops = event.getDrops();
        if (drops == null || drops.isEmpty()) {
            return;
        }
        int fishCount = 0;
        for (ItemStack stack : drops) {
            if (stack.m_41619_() || !stack.m_204117_(ItemTags.f_13156_)) continue;
            fishCount += stack.m_41613_();
        }
        if (fishCount > 0) {
            AutoTitleManager.onFishCaught(player2, fishCount);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        AutoTitleManager.onPlayerTick(player2);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer respawned = (ServerPlayer)player;
        TitleSystem.restoreDisplayedTitle(respawned);
    }
}

