/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import com.fen.mmorpgtitles.AutoTitleEvents;
import com.fen.mmorpgtitles.ModCommands;
import com.fen.mmorpgtitles.TitleChatHandler;
import com.fen.mmorpgtitles.TitleEvents;
import com.fen.mmorpgtitles.TitleSystem;
import com.fen.mmorpgtitles.network.NetworkHandler;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="mmorpgtitles")
public class MmorpgTitlesMod {
    public static final String MOD_ID = "mmorpgtitles";

    public MmorpgTitlesMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new TitleEvents());
        MinecraftForge.EVENT_BUS.register((Object)new TitleChatHandler());
        MinecraftForge.EVENT_BUS.register((Object)new AutoTitleEvents());
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarted);
        System.out.println("The mod Fen's MMORPG Titles has been successfully initialized.");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        System.out.println("[MMORPGTitles] commonSetup called!");
        event.enqueueWork(NetworkHandler::init);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        System.out.println("[MMORPGTitles] Client setup called!");
    }

    private void registerCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    private void onServerStarted(ServerStartedEvent event) {
        System.out.println("[MMORPGTitles] Server started event received!");
        try {
            for (ServerPlayer sp : event.getServer().m_6846_().m_11314_()) {
                TitleSystem.restoreDisplayedTitle(sp);
            }
        }
        catch (Exception e) {
            System.err.println("[MMORPGTitles] Failed to restore displayed titles on server start: " + e.getMessage());
        }
    }
}

