/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import com.fen.mmorpgtitles.ChatFormatData;
import com.fen.mmorpgtitles.TitleConfigData;
import com.fen.mmorpgtitles.TitleData;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TitleChatHandler {
    @SubscribeEvent
    public void onChat(ServerChatEvent event) {
        ServerPlayer player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (!TitleConfigData.get(player.m_284548_()).isChatPrefixEnabled()) {
            return;
        }
        event.setCanceled(true);
        String format = ChatFormatData.get(player.m_284548_()).getFormat();
        MutableComponent finalMessage = this.buildMessage(format, player, event.getMessage());
        player.f_8924_.m_6846_().m_240416_((Component)finalMessage, false);
    }

    private MutableComponent buildMessage(String format, ServerPlayer player, Component message) {
        MutableComponent out = Component.m_237113_((String)"");
        String title = TitleData.getDisplayed(player);
        String titleDesc = title == null || title.isBlank() ? "" : TitleData.getDescription(player, title);
        boolean hasTitle = title != null && !title.isBlank();
        StringBuilder literalBuffer = new StringBuilder();
        Runnable flushLiteral = () -> {
            if (literalBuffer.length() > 0) {
                out.m_7220_((Component)Component.m_237113_((String)literalBuffer.toString()));
                literalBuffer.setLength(0);
            }
        };
        int i = 0;
        while (i < format.length()) {
            if (format.startsWith("{title}", i)) {
                char c;
                char last;
                int bracketPos;
                if (hasTitle) {
                    flushLiteral.run();
                    MutableComponent titleComp = Component.m_237113_((String)("\u00a7r" + title.replace('&', '\u00a7'))).m_130938_(style -> titleDesc.isBlank() ? style : style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)titleDesc))));
                    out.m_7220_((Component)titleComp);
                    i += "{title}".length();
                    continue;
                }
                String openBracket = null;
                for (bracketPos = literalBuffer.length() - 1; bracketPos >= 0 && literalBuffer.charAt(bracketPos) == ' '; --bracketPos) {
                }
                if (bracketPos >= 0 && ((last = literalBuffer.charAt(bracketPos)) == '[' || last == '(' || last == '<' || last == '{')) {
                    openBracket = String.valueOf(last);
                }
                if (openBracket != null) {
                    literalBuffer.setLength(bracketPos);
                    out.m_7220_((Component)Component.m_237113_((String)literalBuffer.toString()));
                    literalBuffer.setLength(0);
                } else {
                    flushLiteral.run();
                }
                i += "{title}".length();
                while (i < format.length() && format.charAt(i) == ' ') {
                    ++i;
                }
                if (i >= format.length() || (c = format.charAt(i)) != ']' && c != ')' && c != '>' && c != '}') continue;
                ++i;
                while (i < format.length() && format.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            if (format.startsWith("{player}", i)) {
                flushLiteral.run();
                out.m_7220_((Component)Component.m_237113_((String)player.m_7755_().getString()));
                i += "{player}".length();
                continue;
            }
            if (format.startsWith("{message}", i)) {
                flushLiteral.run();
                out.m_7220_(message);
                i += "{message}".length();
                continue;
            }
            literalBuffer.append(format.charAt(i));
            ++i;
        }
        flushLiteral.run();
        return out;
    }
}

