/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.escapethebackroomsentity.block;

import net.mcreator.escapethebackroomsentity.block.entity.BodyBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BodyBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public BodyBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.WOOL).strength(1.0f, 10.0f).noCollission().noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)BodyBlock.box((double)3.25, (double)15.5, (double)-5.75, (double)12.75, (double)25.0, (double)3.75), (VoxelShape[])new VoxelShape[]{BodyBlock.box((double)3.0, (double)15.0, (double)-6.0, (double)13.0, (double)25.0, (double)4.0), BodyBlock.box((double)2.25, (double)1.25, (double)1.25, (double)13.75, (double)14.75, (double)6.75), BodyBlock.box((double)8.15, (double)1.25, (double)11.25, (double)13.65, (double)14.75, (double)16.75), BodyBlock.box((double)2.35, (double)1.25, (double)11.25, (double)7.85, (double)14.75, (double)16.75), BodyBlock.box((double)15.25, (double)-6.60321, (double)11.02322, (double)20.75, (double)6.89679, (double)16.52322), BodyBlock.box((double)-3.45622, (double)-1.98647, (double)10.90218, (double)2.04378, (double)11.51353, (double)16.40218)});
            case Direction.NORTH -> Shapes.or((VoxelShape)BodyBlock.box((double)3.25, (double)15.5, (double)12.25, (double)12.75, (double)25.0, (double)21.75), (VoxelShape[])new VoxelShape[]{BodyBlock.box((double)3.0, (double)15.0, (double)12.0, (double)13.0, (double)25.0, (double)22.0), BodyBlock.box((double)2.25, (double)1.25, (double)9.25, (double)13.75, (double)14.75, (double)14.75), BodyBlock.box((double)2.35, (double)1.25, (double)-0.75, (double)7.85, (double)14.75, (double)4.75), BodyBlock.box((double)8.15, (double)1.25, (double)-0.75, (double)13.65, (double)14.75, (double)4.75), BodyBlock.box((double)-4.75, (double)-6.60321, (double)-0.52322, (double)0.75, (double)6.89679, (double)4.97678), BodyBlock.box((double)13.95622, (double)-1.98647, (double)-0.40218, (double)19.45622, (double)11.51353, (double)5.09782)});
            case Direction.EAST -> Shapes.or((VoxelShape)BodyBlock.box((double)-5.75, (double)15.5, (double)3.25, (double)3.75, (double)25.0, (double)12.75), (VoxelShape[])new VoxelShape[]{BodyBlock.box((double)-6.0, (double)15.0, (double)3.0, (double)4.0, (double)25.0, (double)13.0), BodyBlock.box((double)1.25, (double)1.25, (double)2.25, (double)6.75, (double)14.75, (double)13.75), BodyBlock.box((double)11.25, (double)1.25, (double)2.35, (double)16.75, (double)14.75, (double)7.85), BodyBlock.box((double)11.25, (double)1.25, (double)8.15, (double)16.75, (double)14.75, (double)13.65), BodyBlock.box((double)11.02322, (double)-6.60321, (double)-4.75, (double)16.52322, (double)6.89679, (double)0.75), BodyBlock.box((double)10.90218, (double)-1.98647, (double)13.95622, (double)16.40218, (double)11.51353, (double)19.45622)});
            case Direction.WEST -> Shapes.or((VoxelShape)BodyBlock.box((double)12.25, (double)15.5, (double)3.25, (double)21.75, (double)25.0, (double)12.75), (VoxelShape[])new VoxelShape[]{BodyBlock.box((double)12.0, (double)15.0, (double)3.0, (double)22.0, (double)25.0, (double)13.0), BodyBlock.box((double)9.25, (double)1.25, (double)2.25, (double)14.75, (double)14.75, (double)13.75), BodyBlock.box((double)-0.75, (double)1.25, (double)8.15, (double)4.75, (double)14.75, (double)13.65), BodyBlock.box((double)-0.75, (double)1.25, (double)2.35, (double)4.75, (double)14.75, (double)7.85), BodyBlock.box((double)-0.52322, (double)-6.60321, (double)15.25, (double)4.97678, (double)6.89679, (double)20.75), BodyBlock.box((double)-0.40218, (double)-1.98647, (double)-3.45622, (double)5.09782, (double)11.51353, (double)2.04378)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BodyBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(eventID, eventParam);
    }

    protected void affectNeighborsAfterRemoval(BlockState blockstate, ServerLevel world, BlockPos blockpos, boolean flag) {
        Containers.updateNeighboursAfterDestroy((BlockState)blockstate, (Level)world, (BlockPos)blockpos);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof BodyBlockEntity) {
            BodyBlockEntity be = (BodyBlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }
}

