/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.escapethebackroomsentity.client.renderer;

import net.mcreator.escapethebackroomsentity.client.model.ModelBacteria;
import net.mcreator.escapethebackroomsentity.client.model.animations.Bacteria2Animation;
import net.mcreator.escapethebackroomsentity.client.model.animations.BacteriaAnimation;
import net.mcreator.escapethebackroomsentity.entity.BacteriaEntity;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class BacteriaRenderer
extends MobRenderer<BacteriaEntity, LivingEntityRenderState, ModelBacteria> {
    private BacteriaEntity entity = null;

    public BacteriaRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelBacteria.LAYER_LOCATION)), 0.5f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(BacteriaEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"escape_the_backrooms_entity:textures/entities/bacteria_1.png");
    }

    private static final class AnimatedModel
    extends ModelBacteria {
        private BacteriaEntity entity = null;
        private final KeyframeAnimation keyframeAnimation0;
        private final KeyframeAnimation keyframeAnimation1;

        public AnimatedModel(ModelPart root) {
            super(root);
            this.keyframeAnimation0 = BacteriaAnimation.a7.bake(root);
            this.keyframeAnimation1 = Bacteria2Animation.a9.bake(root);
        }

        public void setEntity(BacteriaEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.keyframeAnimation0.apply(this.entity.animationState0, state.ageInTicks, 1.0f);
            this.keyframeAnimation1.applyWalk(state.walkAnimationPos, state.walkAnimationSpeed, 2.5f, 1.0f);
            super.setupAnim(state);
        }
    }
}

