/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.escapethebackroomsentity.client.renderer;

import net.mcreator.escapethebackroomsentity.client.model.ModelBonestiler;
import net.mcreator.escapethebackroomsentity.client.model.animations.BonestilerAnimation;
import net.mcreator.escapethebackroomsentity.entity.BonestilerEntity;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class BonestilerRenderer
extends MobRenderer<BonestilerEntity, LivingEntityRenderState, ModelBonestiler> {
    private BonestilerEntity entity = null;

    public BonestilerRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelBonestiler.LAYER_LOCATION)), 0.5f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(BonestilerEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"escape_the_backrooms_entity:textures/entities/bone_stile.png");
    }

    private static final class AnimatedModel
    extends ModelBonestiler {
        private BonestilerEntity entity = null;
        private final KeyframeAnimation keyframeAnimation0;

        public AnimatedModel(ModelPart root) {
            super(root);
            this.keyframeAnimation0 = BonestilerAnimation.animation.bake(root);
        }

        public void setEntity(BonestilerEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.keyframeAnimation0.apply(this.entity.animationState0, state.ageInTicks, 0.5f);
            super.setupAnim(state);
        }
    }
}

