/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry;

import com.binaris.wizardry.api.content.event.EBPlayerBreakBlockEvent;
import com.binaris.wizardry.api.content.event.EBPlayerInteractEntityEvent;
import com.binaris.wizardry.api.content.event.EBPlayerJoinServerEvent;
import com.binaris.wizardry.api.content.event.EBPlayerUseBlockEvent;
import com.binaris.wizardry.api.content.event.EBServerLevelLoadEvent;
import com.binaris.wizardry.api.content.util.RegisterFunction;
import com.binaris.wizardry.capabilities.ArcaneLockDataHolder;
import com.binaris.wizardry.capabilities.CastCommandDataHolder;
import com.binaris.wizardry.capabilities.ConjureDataHolder;
import com.binaris.wizardry.capabilities.ContainmentDataHolder;
import com.binaris.wizardry.capabilities.ImbuementEnchantDataHolder;
import com.binaris.wizardry.capabilities.MinionDataHolder;
import com.binaris.wizardry.capabilities.SpellManagerDataHolder;
import com.binaris.wizardry.capabilities.WizardDataHolder;
import com.binaris.wizardry.content.spell.abstr.ConjureItemSpell;
import com.binaris.wizardry.core.PropertiesForgeDataManager;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.core.registry.EBRegistries;
import com.binaris.wizardry.network.ArcaneLockSyncPacketS2C;
import com.binaris.wizardry.setup.registries.EBBlockEntities;
import com.binaris.wizardry.setup.registries.EBBlocks;
import com.binaris.wizardry.setup.registries.EBCreativeTabs;
import com.binaris.wizardry.setup.registries.EBEnchantments;
import com.binaris.wizardry.setup.registries.EBEntities;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBLootFunctions;
import com.binaris.wizardry.setup.registries.EBLootTables;
import com.binaris.wizardry.setup.registries.EBMenus;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.EBRecipeTypes;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticleProviders;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import com.binaris.wizardry.setup.registries.client.EBRenderers;
import java.util.function.Consumer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterGameTestsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegisterEvent;

public class WizardryForgeEvents {

    @Mod.EventBusSubscriber(modid="ebwizardry", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ModBusEventsClient {
        @SubscribeEvent
        public static void registerProviders(RegisterParticleProvidersEvent event) {
            EBParticleProviders.registerProvider((type, provider) -> event.registerSpriteSet((ParticleType)type.get(), provider::apply));
        }

        @SubscribeEvent
        public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            EBRenderers.createEntityLayers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1));
        }
    }

    @Mod.EventBusSubscriber(modid="ebwizardry", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void registerContent(RegisterEvent event) {
            if (event.getRegistryKey() == Registries.f_256929_) {
                ModBusEvents.register(event, EBMobEffects::register);
            } else if (event.getRegistryKey() == Registries.f_256747_) {
                ModBusEvents.register(event, EBBlocks::register);
            } else if (event.getRegistryKey() == Registries.f_256922_) {
                ModBusEvents.register(event, EBBlockEntities::register);
            } else if (event.getRegistryKey() == Registries.f_279569_) {
                ModBusEvents.register(event, EBCreativeTabs::register);
            } else if (event.getRegistryKey() == Registries.f_256939_) {
                ModBusEvents.register(event, EBEntities::register);
            } else if (event.getRegistryKey() == Registries.f_256913_) {
                ModBusEvents.register(event, EBItems::register);
            } else if (event.getRegistryKey() == Registries.f_256890_) {
                ModBusEvents.register(event, EBParticles::registerType);
            } else if (event.getRegistryKey() == Registries.f_256840_) {
                ModBusEvents.register(event, EBSounds::register);
            } else if (event.getRegistryKey() == Registries.f_257015_) {
                ModBusEvents.register(event, EBLootFunctions::register);
            } else if (event.getRegistryKey() == Registries.f_256762_) {
                ModBusEvents.register(event, EBEnchantments::register);
            } else if (event.getRegistryKey() == Registries.f_256798_) {
                ModBusEvents.register(event, EBMenus::register);
            } else if (event.getRegistryKey() == Registries.f_256954_) {
                ModBusEvents.register(event, EBRecipeTypes::register);
            } else if (event.getRegistryKey() == Registries.f_256764_) {
                ModBusEvents.register(event, EBRecipeTypes::registerSerializers);
            } else if (event.getRegistryKey() == EBRegistries.ELEMENT) {
                ModBusEvents.registerForge(event, Elements::registerNull);
            } else if (event.getRegistryKey() == EBRegistries.TIER) {
                ModBusEvents.registerForge(event, SpellTiers::registerNull);
            } else if (event.getRegistryKey() == EBRegistries.SPELL) {
                ModBusEvents.registerForge(event, Spells::registerNull);
            }
        }

        private static <T> void registerForge(RegisterEvent event, Consumer<RegisterFunction<T>> consumer) {
            consumer.accept((registry, id, value) -> event.register(event.getForgeRegistry().getRegistryKey(), id, () -> value));
        }

        private static <T> void register(RegisterEvent event, Consumer<RegisterFunction<T>> consumer) {
            consumer.accept((registry, id, value) -> event.register(registry.m_123023_(), id, () -> value));
        }

        @SubscribeEvent
        public static void createEntityAttributes(EntityAttributeCreationEvent event) {
            EBEntities.registerAttributes((arg_0, arg_1) -> ((EntityAttributeCreationEvent)event).put(arg_0, arg_1));
        }

        @SubscribeEvent
        public static void registerTests(RegisterGameTestsEvent event) {
        }
    }

    @Mod.EventBusSubscriber(modid="ebwizardry", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeBusEvents {
        @SubscribeEvent
        public static void onWorldLoadEvent(LevelEvent.Load event) {
            if (event.getLevel().m_5776_()) {
                return;
            }
            WizardryEventBus.getInstance().fire(new EBServerLevelLoadEvent((Level)((ServerLevel)event.getLevel())));
        }

        @SubscribeEvent
        public static void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
            WizardryEventBus.getInstance().fire(new EBPlayerJoinServerEvent(event.getEntity(), event.getEntity().m_20194_()));
            Player player = event.getEntity();
            if (!player.m_9236_().m_5776_()) {
                player.getCapability(WizardDataHolder.INSTANCE).ifPresent(WizardDataHolder::sync);
                player.getCapability(CastCommandDataHolder.INSTANCE).ifPresent(CastCommandDataHolder::sync);
                player.getCapability(SpellManagerDataHolder.INSTANCE).ifPresent(SpellManagerDataHolder::sync);
            }
        }

        @SubscribeEvent
        public static void onLootTableLoadEvent(LootTableLoadEvent event) {
            EBLootTables.applyInjections((location, pool) -> {
                if (event.getName().equals(location)) {
                    event.getTable().addPool(pool);
                }
            });
        }

        @SubscribeEvent
        public static void registerReloadListeners(AddReloadListenerEvent event) {
            event.addListener((PreparableReloadListener)new PropertiesForgeDataManager());
        }

        @SubscribeEvent
        public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
            if (WizardryEventBus.getInstance().fire(new EBPlayerInteractEntityEvent(event.getEntity(), event.getTarget()))) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onBlockUse(PlayerInteractEvent.RightClickBlock event) {
            if (WizardryEventBus.getInstance().fire(new EBPlayerUseBlockEvent(event.getEntity(), event.getLevel(), event.getPos(), event.getHand()))) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onBlockBreak(BlockEvent.BreakEvent event) {
            if (WizardryEventBus.getInstance().fire(new EBPlayerBreakBlockEvent(event.getPlayer(), (Level)event.getLevel(), event.getPos()))) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onChunkWatch(ChunkWatchEvent.Watch event) {
            ServerLevel level = event.getLevel();
            LevelChunk chunk = level.m_6325_(event.getPos().f_45578_, event.getPos().f_45579_);
            for (BlockEntity blockEntity : chunk.m_62954_().values()) {
                if (!(blockEntity instanceof BaseContainerBlockEntity)) continue;
                blockEntity.getCapability(ArcaneLockDataHolder.INSTANCE).ifPresent(data -> {
                    if (data.isArcaneLocked()) {
                        ArcaneLockSyncPacketS2C packet = new ArcaneLockSyncPacketS2C(blockEntity.m_58899_(), data.serializeNBT());
                        Services.NETWORK_HELPER.sendTo(event.getPlayer(), packet);
                    }
                });
            }
        }

        @SubscribeEvent
        public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
            Object object = event.getObject();
            if (object instanceof Player) {
                Player player = (Player)object;
                event.addCapability(CastCommandDataHolder.LOCATION, (ICapabilityProvider)new CastCommandDataHolder.Provider(player));
                event.addCapability(SpellManagerDataHolder.LOCATION, (ICapabilityProvider)new SpellManagerDataHolder.Provider(player));
                event.addCapability(WizardDataHolder.LOCATION, (ICapabilityProvider)new WizardDataHolder.Provider(player));
            }
            if ((object = event.getObject()) instanceof Mob) {
                Mob mob = (Mob)object;
                event.addCapability(MinionDataHolder.LOCATION, (ICapabilityProvider)new MinionDataHolder.Provider(mob));
            }
            if ((object = event.getObject()) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)object;
                event.addCapability(ContainmentDataHolder.LOCATION, (ICapabilityProvider)new ContainmentDataHolder.Provider(livingEntity));
            }
        }

        @SubscribeEvent
        public static void attachCapabilityBlock(AttachCapabilitiesEvent<BlockEntity> event) {
            if (event.getObject() instanceof BaseContainerBlockEntity) {
                event.addCapability(ArcaneLockDataHolder.LOCATION, (ICapabilityProvider)new ArcaneLockDataHolder.Provider((BlockEntity)event.getObject()));
            }
        }

        @SubscribeEvent
        public static void attachCapabilityItem(AttachCapabilitiesEvent<ItemStack> event) {
            if (ConjureItemSpell.isSummonableItem(((ItemStack)event.getObject()).m_41720_())) {
                ConjureDataHolder.Provider provider = new ConjureDataHolder.Provider((ItemStack)event.getObject());
                event.addCapability(ConjureDataHolder.LOCATION, (ICapabilityProvider)provider);
            }
            if (((ItemStack)event.getObject()).m_41782_()) {
                event.addCapability(ImbuementEnchantDataHolder.LOCATION, (ICapabilityProvider)new ImbuementEnchantDataHolder.Provider((ItemStack)event.getObject()));
            }
        }

        @SubscribeEvent
        public static void onPlayerCloned(PlayerEvent.Clone event) {
            if (!event.isWasDeath()) {
                return;
            }
            event.getOriginal().reviveCaps();
            event.getOriginal().getCapability(WizardDataHolder.INSTANCE).ifPresent(old -> event.getEntity().getCapability(WizardDataHolder.INSTANCE).ifPresent(holder -> holder.copyFrom((WizardDataHolder)old)));
            event.getOriginal().getCapability(SpellManagerDataHolder.INSTANCE).ifPresent(old -> event.getEntity().getCapability(SpellManagerDataHolder.INSTANCE).ifPresent(holder -> holder.copyFrom((SpellManagerDataHolder)old)));
            event.getOriginal().getCapability(CastCommandDataHolder.INSTANCE).ifPresent(old -> event.getEntity().getCapability(CastCommandDataHolder.INSTANCE).ifPresent(holder -> holder.copyFrom((CastCommandDataHolder)old)));
            event.getOriginal().invalidateCaps();
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (!player.m_9236_().m_5776_()) {
                player.getCapability(WizardDataHolder.INSTANCE).ifPresent(WizardDataHolder::sync);
                player.getCapability(SpellManagerDataHolder.INSTANCE).ifPresent(SpellManagerDataHolder::sync);
                player.getCapability(CastCommandDataHolder.INSTANCE).ifPresent(CastCommandDataHolder::sync);
            }
        }

        @SubscribeEvent
        public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
            event.register(WizardDataHolder.class);
            event.register(SpellManagerDataHolder.class);
            event.register(CastCommandDataHolder.class);
            event.register(MinionDataHolder.class);
            event.register(ContainmentDataHolder.class);
            event.register(ConjureDataHolder.class);
            event.register(ImbuementEnchantDataHolder.class);
            event.register(ArcaneLockDataHolder.class);
        }
    }
}

