/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.client;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.content.DeferredObject;
import com.binaris.wizardry.client.ParticleSpawner;
import com.binaris.wizardry.core.networking.s2c.ParticleBuilderS2C;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public final class ParticleBuilder {
    private static final ParticleBuilder instance = new ParticleBuilder();
    private SimpleParticleType particle;
    private Level world;
    private boolean building;
    private int lifetime;
    private float scale;
    private double x;
    private double y;
    private double z;
    private float red;
    private float green;
    private float blue;
    private double velocityX;
    private double velocityY;
    private double velocityZ;
    private float fadeRed;
    private float fadeGreen;
    private float fadeBlue;
    private boolean shaded;
    private boolean gravity;
    private boolean serverAllowed;
    private long seed;
    private double length;
    private Entity entity;
    private float yaw;
    private float pitch;
    private double radius;
    private double rpt;
    private boolean collide;
    private double tx;
    private double ty;
    private double tz;
    private double tvx;
    private double tvy;
    private double tvz;
    private Entity target;

    public static ParticleBuilder create(DeferredObject<SimpleParticleType> particle) {
        return instance.particle(particle);
    }

    public static ParticleBuilder create(DeferredObject<SimpleParticleType> type, Entity entity) {
        double x = entity.f_19854_ + (entity.m_9236_().f_46441_.m_188500_() - 0.5) * (double)entity.m_20205_();
        double y = entity.f_19855_ + entity.m_9236_().f_46441_.m_188500_() * (double)entity.m_20205_();
        double z = entity.f_19856_ + (entity.m_9236_().f_46441_.m_188500_() - 0.5) * (double)entity.m_20205_();
        return instance.particle(type).pos(x, y, z);
    }

    public static ParticleBuilder create(DeferredObject<SimpleParticleType> type, RandomSource random, double x, double y, double z, double radius) {
        double px = x + (random.m_188500_() * 2.0 - 1.0) * radius;
        double py = y + (random.m_188500_() * 2.0 - 1.0) * radius;
        double pz = z + (random.m_188500_() * 2.0 - 1.0) * radius;
        return ParticleBuilder.create(type).pos(px, py, pz);
    }

    public static ParticleBuilder create(DeferredObject<SimpleParticleType> type, RandomSource random, double x, double y, double z, double radius, boolean move) {
        double px = x + (random.m_188500_() * 2.0 - 1.0) * radius;
        double py = y + (random.m_188500_() * 2.0 - 1.0) * radius;
        double pz = z + (random.m_188500_() * 2.0 - 1.0) * radius;
        if (move) {
            return ParticleBuilder.create(type).pos(px, py, pz).velocity(px - x, py - y, pz - z);
        }
        return ParticleBuilder.create(type).pos(px, py, pz);
    }

    public static void spawnShockParticles(Level world, double x, double y, double z) {
        for (int i = 0; i < 8; ++i) {
            double px = x + world.f_46441_.m_188500_() - 0.5;
            double py = y + world.f_46441_.m_188500_() + 0.5;
            double pz = z + world.f_46441_.m_188500_() - 0.5;
            ParticleBuilder.create(EBParticles.SPARK).pos(px, py, pz).spawn(world);
            px = x + world.f_46441_.m_188500_() - 0.5;
            py = y + world.f_46441_.m_188500_() - 0.5;
            pz = z + world.f_46441_.m_188500_() - 0.5;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123755_, px, py, pz, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnHealParticles(Level world, LivingEntity entity) {
        for (int i = 0; i < 10; ++i) {
            double x = entity.m_20185_() + world.f_46441_.m_188500_() * 2.0 - 1.0;
            double y = entity.m_20185_() + (double)(entity.m_6972_((Pose)entity.m_20089_()).f_20378_ * 0.85f) - 0.5 + world.f_46441_.m_188500_();
            double z = entity.m_20185_() + world.f_46441_.m_188500_() * 2.0 - 1.0;
            ParticleBuilder.create(EBParticles.SPARKLE).pos(x, y, z).velocity(0.0, 0.1, 0.0).color(1.0f, 1.0f, 0.3f).spawn(world);
        }
        ParticleBuilder.create(EBParticles.BUFF).entity((Entity)entity).color(1.0f, 1.0f, 0.3f).spawn(world);
    }

    private ParticleBuilder particle(DeferredObject<SimpleParticleType> particle) {
        if (ParticleBuilder.instance.building) {
            EBLogger.warn("Attempted to build an already built particle: " + this.getCurrentParticleString(), new Object[0]);
            return instance;
        }
        this.particle = particle.get();
        this.building = true;
        return this;
    }

    private String getCurrentParticleString() {
        return String.format("[ Type: %s, Position: (%s, %s, %s), Velocity: (%s, %s, %s), Colour: (%s, %s, %s), Fade Colour: (%s, %s, %s), Radius: %s, Revs/tick: %s, Lifetime: %s, Gravity: %s, Shaded: %s, Scale: %s, Entity: %s ]", this.particle, this.x, this.y, this.z, this.velocityX, this.velocityY, this.velocityZ, Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.fadeRed), Float.valueOf(this.fadeGreen), Float.valueOf(this.fadeBlue), this.radius, this.rpt, this.lifetime, this.gravity, this.shaded, Float.valueOf(this.scale), this.entity);
    }

    public ParticleBuilder pos(double x, double y, double z) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public ParticleBuilder pos(BlockPos pos) {
        return this.pos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public ParticleBuilder pos(Vec3 vec3d) {
        return this.pos(vec3d.m_7096_(), vec3d.m_7098_(), vec3d.m_7094_());
    }

    public ParticleBuilder time(int lifetime) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.lifetime = lifetime;
        return this;
    }

    public ParticleBuilder velocity(double velocityX, double velocityY, double velocityZ) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.velocityX = velocityX;
        this.velocityY = velocityY;
        this.velocityZ = velocityZ;
        return this;
    }

    public ParticleBuilder velocity(Vec3 vel) {
        return this.velocity(vel.f_82479_, vel.f_82480_, vel.f_82481_);
    }

    public ParticleBuilder scale(float scale) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.scale = scale;
        return this;
    }

    public ParticleBuilder color(float r, float g, float b) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.red = Mth.m_14036_((float)r, (float)0.0f, (float)1.0f);
        this.green = Mth.m_14036_((float)g, (float)0.0f, (float)1.0f);
        this.blue = Mth.m_14036_((float)b, (float)0.0f, (float)1.0f);
        return this;
    }

    public ParticleBuilder color(int r, int g, int b) {
        return this.color((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public ParticleBuilder color(int hex) {
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        return this.color(r, g, b);
    }

    public ParticleBuilder fade(float r, float g, float b) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.fadeRed = Mth.m_14036_((float)r, (float)0.0f, (float)1.0f);
        this.fadeGreen = Mth.m_14036_((float)g, (float)0.0f, (float)1.0f);
        this.fadeBlue = Mth.m_14036_((float)b, (float)0.0f, (float)1.0f);
        return this;
    }

    public ParticleBuilder fade(int r, int g, int b) {
        return this.fade((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public ParticleBuilder fade(int hex) {
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        return this.fade(r, g, b);
    }

    public ParticleBuilder seed(long seed) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.seed = seed;
        return this;
    }

    public ParticleBuilder spin(double radius, double speed) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.radius = radius;
        this.rpt = speed;
        return this;
    }

    public ParticleBuilder collide(boolean collide) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.collide = collide;
        return this;
    }

    public ParticleBuilder entity(Entity entity) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.entity = entity;
        return this;
    }

    public ParticleBuilder face(float yaw, float pitch) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.yaw = yaw;
        this.pitch = pitch;
        return this;
    }

    public ParticleBuilder face(Direction direction) {
        return this.face(direction.m_122435_(), direction.m_122434_().m_122478_() ? (float)(direction.m_122421_().m_122540_() * 90) : 0.0f);
    }

    public ParticleBuilder allowServer(boolean allow) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.serverAllowed = allow;
        return this;
    }

    public ParticleBuilder shaded(boolean value) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.shaded = value;
        return this;
    }

    public ParticleBuilder gravity(boolean value) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.gravity = value;
        return this;
    }

    public ParticleBuilder target(double x, double y, double z) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.tx = x;
        this.ty = y;
        this.tz = z;
        return this;
    }

    public ParticleBuilder target(Vec3 pos) {
        return this.target(pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    public ParticleBuilder tvel(double vx, double vy, double vz) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.tvx = vx;
        this.tvy = vy;
        this.tvz = vz;
        return this;
    }

    public ParticleBuilder tvel(Vec3 vel) {
        return this.tvel(vel.f_82479_, vel.f_82480_, vel.f_82481_);
    }

    public ParticleBuilder length(double length) {
        this.length = length;
        return this;
    }

    public ParticleBuilder target(Entity target) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.target = target;
        return this;
    }

    public void spawn(Level world) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        if (this.x == 0.0 && this.y == 0.0 && this.z == 0.0 && this.entity == null) {
            EBLogger.error("Failed to spawn particle of type - %s - are you sure it exists?", new Object[0]);
        }
        if (this.serverAllowed && !world.m_5776_()) {
            ParticleData data = this.captureData();
            ParticleBuilderS2C packet = new ParticleBuilderS2C(data);
            Services.NETWORK_HELPER.sendToDimension(world.m_7654_(), packet, (ResourceKey<Level>)world.m_46472_());
            this.reset();
            return;
        }
        if (!world.m_5776_()) {
            EBLogger.error("ParticleBuilder.spawn(...) called on the server side! ParticleBuilder has prevented a server crash, but calling it on the server will do nothing. Consider adding a world.isClientSide() check or use .serverAllowed(true) to send particles to clients.", new Object[0]);
            this.reset();
            return;
        }
        ParticleSpawner.spawnClientParticle(this.captureData());
        this.reset();
    }

    private ParticleData captureData() {
        ParticleData data = new ParticleData();
        data.particleType = BuiltInRegistries.f_257034_.m_7981_((Object)this.particle);
        data.x = this.x;
        data.y = this.y;
        data.z = this.z;
        data.vx = this.velocityX;
        data.vy = this.velocityY;
        data.vz = this.velocityZ;
        data.r = this.red;
        data.g = this.green;
        data.b = this.blue;
        data.fr = this.fadeRed;
        data.fg = this.fadeGreen;
        data.fb = this.fadeBlue;
        data.lifetime = this.lifetime;
        data.scale = this.scale;
        data.gravity = this.gravity;
        data.shaded = this.shaded;
        data.collide = this.collide;
        data.radius = this.radius;
        data.rpt = this.rpt;
        data.yaw = this.yaw;
        data.pitch = this.pitch;
        data.seed = this.seed;
        data.length = this.length;
        data.tx = this.tx;
        data.ty = this.ty;
        data.tz = this.tz;
        data.tvx = this.tvx;
        data.tvy = this.tvy;
        data.tvz = this.tvz;
        data.entityId = this.entity != null ? Integer.valueOf(this.entity.m_19879_()) : null;
        data.targetId = this.target != null ? Integer.valueOf(this.target.m_19879_()) : null;
        return data;
    }

    private void reset() {
        this.building = false;
        this.particle = null;
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.velocityX = Double.NaN;
        this.velocityY = Double.NaN;
        this.velocityZ = Double.NaN;
        this.red = -1.0f;
        this.green = -1.0f;
        this.blue = -1.0f;
        this.fadeRed = -1.0f;
        this.fadeGreen = -1.0f;
        this.fadeBlue = -1.0f;
        this.radius = 0.0;
        this.rpt = 0.0;
        this.lifetime = -1;
        this.gravity = false;
        this.shaded = false;
        this.collide = false;
        this.scale = 1.0f;
        this.entity = null;
        this.yaw = Float.NaN;
        this.pitch = Float.NaN;
        this.tx = Double.NaN;
        this.ty = Double.NaN;
        this.tz = Double.NaN;
        this.tvx = Double.NaN;
        this.tvy = Double.NaN;
        this.tvz = Double.NaN;
        this.target = null;
        this.seed = 0L;
        this.length = -1.0;
        this.serverAllowed = false;
    }

    public static class ParticleData {
        public ResourceLocation particleType;
        public double x;
        public double y;
        public double z;
        public double vx;
        public double vy;
        public double vz;
        public float r;
        public float g;
        public float b;
        public float fr;
        public float fg;
        public float fb;
        public int lifetime;
        public float scale;
        public boolean gravity;
        public boolean shaded;
        public boolean collide;
        public double radius;
        public double rpt;
        public float yaw;
        public float pitch;
        public long seed;
        public double length;
        public double tx;
        public double ty;
        public double tz;
        public double tvx;
        public double tvy;
        public double tvz;
        public Integer entityId;
        public Integer targetId;

        public static ParticleData read(FriendlyByteBuf buf) {
            ParticleData data = new ParticleData();
            data.particleType = buf.m_130281_();
            data.x = buf.readDouble();
            data.y = buf.readDouble();
            data.z = buf.readDouble();
            data.vx = buf.readDouble();
            data.vy = buf.readDouble();
            data.vz = buf.readDouble();
            data.r = buf.readFloat();
            data.g = buf.readFloat();
            data.b = buf.readFloat();
            data.fr = buf.readFloat();
            data.fg = buf.readFloat();
            data.fb = buf.readFloat();
            data.lifetime = buf.readInt();
            data.scale = buf.readFloat();
            data.gravity = buf.readBoolean();
            data.shaded = buf.readBoolean();
            data.collide = buf.readBoolean();
            data.radius = buf.readDouble();
            data.rpt = buf.readDouble();
            data.yaw = buf.readFloat();
            data.pitch = buf.readFloat();
            data.seed = buf.readLong();
            data.length = buf.readDouble();
            data.tx = buf.readDouble();
            data.ty = buf.readDouble();
            data.tz = buf.readDouble();
            data.tvx = buf.readDouble();
            data.tvy = buf.readDouble();
            data.tvz = buf.readDouble();
            if (buf.readBoolean()) {
                data.entityId = buf.readInt();
            }
            if (buf.readBoolean()) {
                data.targetId = buf.readInt();
            }
            return data;
        }

        public void write(FriendlyByteBuf buf) {
            buf.m_130085_(this.particleType);
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
            buf.writeDouble(this.vx);
            buf.writeDouble(this.vy);
            buf.writeDouble(this.vz);
            buf.writeFloat(this.r);
            buf.writeFloat(this.g);
            buf.writeFloat(this.b);
            buf.writeFloat(this.fr);
            buf.writeFloat(this.fg);
            buf.writeFloat(this.fb);
            buf.writeInt(this.lifetime);
            buf.writeFloat(this.scale);
            buf.writeBoolean(this.gravity);
            buf.writeBoolean(this.shaded);
            buf.writeBoolean(this.collide);
            buf.writeDouble(this.radius);
            buf.writeDouble(this.rpt);
            buf.writeFloat(this.yaw);
            buf.writeFloat(this.pitch);
            buf.writeLong(this.seed);
            buf.writeDouble(this.length);
            buf.writeDouble(this.tx);
            buf.writeDouble(this.ty);
            buf.writeDouble(this.tz);
            buf.writeDouble(this.tvx);
            buf.writeDouble(this.tvy);
            buf.writeDouble(this.tvz);
            buf.writeBoolean(this.entityId != null);
            if (this.entityId != null) {
                buf.writeInt(this.entityId.intValue());
            }
            buf.writeBoolean(this.targetId != null);
            if (this.targetId != null) {
                buf.writeInt(this.targetId.intValue());
            }
        }
    }
}

