/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.client.particle;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.client.particle.ParticleWizardry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ParticleTargeted
extends ParticleWizardry {
    private static final double THIRD_PERSON_AXIAL_OFFSET = 1.2;
    protected double targetX;
    protected double targetY;
    protected double targetZ;
    protected double targetVelX;
    protected double targetVelY;
    protected double targetVelZ;
    protected double length;
    @Nullable
    protected Entity target = null;

    public ParticleTargeted(ClientLevel world, double x, double y, double z, SpriteSet spriteProvider, boolean updateTextureOnTick) {
        super(world, x, y, z, spriteProvider, updateTextureOnTick);
    }

    @Override
    public void setTargetPosition(double x, double y, double z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
    }

    @Override
    public void setTargetVelocity(double vx, double vy, double vz) {
        this.targetVelX = vx;
        this.targetVelY = vy;
        this.targetVelZ = vz;
    }

    @Override
    public void setTargetEntity(Entity target) {
        this.target = target;
    }

    @Override
    public void setLength(double length) {
        this.length = length;
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        if (!(Double.isNaN(this.targetVelX) || Double.isNaN(this.targetVelY) || Double.isNaN(this.targetVelZ))) {
            this.targetX += this.targetVelX;
            this.targetY += this.targetVelY;
            this.targetZ += this.targetVelZ;
        }
    }

    private Vec3 getPosition(Entity entity, double yOffset, float partialTick) {
        double d0 = Mth.m_14139_((double)partialTick, (double)entity.f_19790_, (double)entity.m_20185_());
        double d1 = Mth.m_14139_((double)partialTick, (double)entity.f_19791_, (double)entity.m_20186_()) + yOffset;
        double d2 = Mth.m_14139_((double)partialTick, (double)entity.f_19792_, (double)entity.m_20189_());
        return new Vec3(d0, d1, d2);
    }

    @Override
    protected void updateEntityLinking(float partialTicks) {
    }

    @Override
    public void m_5744_(@NotNull VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        double finalTargetZ;
        double finalTargetY;
        double finalTargetX;
        double originZ;
        double originY;
        double originX;
        Entity viewer = camera.m_90592_();
        PoseStack stack = new PoseStack();
        if (this.entity != null) {
            Vec3 entityPos = this.getPosition(this.entity, 0.0, tickDelta);
            originX = entityPos.f_82479_ + this.relativeX;
            originY = entityPos.f_82480_ + this.relativeY;
            originZ = entityPos.f_82481_ + this.relativeZ;
        } else {
            originX = Mth.m_14139_((double)tickDelta, (double)this.f_107209_, (double)this.f_107212_);
            originY = Mth.m_14139_((double)tickDelta, (double)this.f_107210_, (double)this.f_107213_);
            originZ = Mth.m_14139_((double)tickDelta, (double)this.f_107211_, (double)this.f_107214_);
        }
        if (this.entity != null && this.shouldApplyOriginOffset()) {
            boolean isFirstPerson;
            boolean bl = isFirstPerson = this.entity == viewer && Minecraft.m_91087_().f_91066_.m_92176_() != CameraType.THIRD_PERSON_FRONT;
            if (!isFirstPerson || this.shouldApplyOriginOffsetInFirstPerson()) {
                Vec3 look = this.entity.m_20252_(tickDelta).m_82490_(1.2);
                originX += look.f_82479_;
                originY += look.f_82480_;
                originZ += look.f_82481_;
            }
        }
        if (this.target != null) {
            Vec3 targetPos = this.getPosition(this.target, (double)this.target.m_20206_() * 0.5, tickDelta);
            finalTargetX = targetPos.f_82479_;
            finalTargetY = targetPos.f_82480_;
            finalTargetZ = targetPos.f_82481_;
        } else if (this.entity != null && this.length > 0.0) {
            Vec3 look = this.entity.m_20252_(tickDelta).m_82490_(this.length);
            finalTargetX = originX + look.f_82479_;
            finalTargetY = originY + look.f_82480_;
            finalTargetZ = originZ + look.f_82481_;
        } else {
            finalTargetX = this.targetX;
            finalTargetY = this.targetY;
            finalTargetZ = this.targetZ;
            if (!(Double.isNaN(this.targetVelX) || Double.isNaN(this.targetVelY) || Double.isNaN(this.targetVelZ))) {
                finalTargetX += (double)tickDelta * this.targetVelX;
                finalTargetY += (double)tickDelta * this.targetVelY;
                finalTargetZ += (double)tickDelta * this.targetVelZ;
            }
        }
        if (Double.isNaN(finalTargetX) || Double.isNaN(finalTargetY) || Double.isNaN(finalTargetZ)) {
            EBLogger.error("Attempted to render a targeted particle, but neither its target entity nor target position was set, and it either had no length assigned or was not linked to an entity.", new Object[0]);
            return;
        }
        stack.m_85836_();
        stack.m_85837_(originX - camera.m_90583_().f_82479_, originY - camera.m_90583_().f_82480_, originZ - camera.m_90583_().f_82481_);
        double dx = finalTargetX - originX;
        double dy = finalTargetY - originY;
        double dz = finalTargetZ - originZ;
        float beamLength = Mth.m_14116_((float)((float)(dx * dx + dy * dy + dz * dz)));
        Vec3 direction = new Vec3(dx, dy, dz).m_82541_();
        float yaw = (float)(Math.atan2(direction.f_82479_, direction.f_82481_) * 180.0 / Math.PI);
        float pitch = (float)(Math.asin(-direction.f_82480_) * 180.0 / Math.PI);
        stack.m_252781_(Axis.f_252436_.m_252977_(yaw));
        stack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        Tesselator tesselator = Tesselator.m_85913_();
        this.draw(stack, tesselator, beamLength, tickDelta);
        stack.m_85849_();
    }

    protected boolean shouldApplyOriginOffset() {
        return true;
    }

    protected boolean shouldApplyOriginOffsetInFirstPerson() {
        return false;
    }

    protected abstract void draw(PoseStack var1, Tesselator var2, float var3, float var4);
}

