/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.client.particle;

import com.binaris.wizardry.api.content.entity.ICustomHitbox;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ParticleWizardry
extends TextureSheetParticle {
    public static final Map<SimpleParticleType, BiFunction<ClientLevel, Vec3, ParticleWizardry>> PROVIDERS = new LinkedHashMap<SimpleParticleType, BiFunction<ClientLevel, Vec3, ParticleWizardry>>();
    private static final double SPREAD_FACTOR = 0.2;
    private static final double IMPACT_FRICTION = 0.2;
    private final boolean updateTextureOnTick;
    protected long seed;
    protected Random random = new Random();
    protected boolean shaded = false;
    protected float initialRed;
    protected float initialGreen;
    protected float initialBlue;
    protected float fadeRed = 0.0f;
    protected float fadeGreen = 0.0f;
    protected float fadeBlue = 0.0f;
    protected float angle;
    protected double radius = 0.0;
    protected double speed = 0.0;
    @Nullable
    protected Entity entity = null;
    protected double relativeX;
    protected double relativeY;
    protected double relativeZ;
    protected double relativeMotionX;
    protected double relativeMotionY;
    protected double relativeMotionZ;
    protected float yaw = Float.NaN;
    protected float pitch = Float.NaN;
    protected boolean adjustQuadSize;
    SpriteSet spriteSet;
    private double prevVelX;
    private double prevVelY;
    private double prevVelZ;

    public ParticleWizardry(ClientLevel world, double x, double y, double z, SpriteSet spriteSet, boolean updateTextureOnTick) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.relativeX = this.f_107212_;
        this.relativeY = this.f_107213_;
        this.relativeZ = this.f_107214_;
        this.updateTextureOnTick = updateTextureOnTick;
        this.m_108339_(spriteSet);
    }

    public void setSeed(long seed) {
        this.seed = seed;
        this.random = new Random(seed);
    }

    public void setShaded(boolean shaded) {
        this.shaded = shaded;
    }

    public void setGravity(boolean gravity) {
        this.f_107226_ = gravity ? 1.0f : 0.0f;
    }

    public void setCollisions(boolean canCollide) {
        this.f_107219_ = canCollide;
    }

    public void m_172260_(double velocityX, double velocityY, double velocityZ) {
        super.m_172260_(velocityX, velocityY, velocityZ);
    }

    public void setSpin(double radius, double speed) {
        this.radius = radius;
        this.speed = speed * 2.0 * Math.PI;
        this.angle = this.random.nextFloat() * (float)Math.PI * 2.0f;
        this.f_107212_ = this.relativeX - radius * (double)Mth.m_14089_((float)this.angle);
        this.f_107214_ = this.relativeZ + radius * (double)Mth.m_14031_((float)this.angle);
        this.relativeMotionX = this.f_107215_;
        this.relativeMotionY = this.f_107216_;
        this.relativeMotionZ = this.f_107217_;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
        if (entity != null) {
            this.m_107264_(this.entity.f_19854_ + this.relativeX, this.entity.f_19855_ + this.relativeY, this.entity.f_19856_ + this.relativeZ);
            this.f_107209_ = this.f_107212_;
            this.f_107210_ = this.f_107213_;
            this.f_107211_ = this.f_107214_;
            this.relativeMotionX = this.f_107215_;
            this.relativeMotionY = this.f_107216_;
            this.relativeMotionZ = this.f_107217_;
        }
    }

    public void m_107253_(float red, float green, float blue) {
        super.m_107253_(red, green, blue);
        this.initialRed = red;
        this.initialGreen = green;
        this.initialBlue = blue;
        this.setFadeColour(red, green, blue);
    }

    public void setFadeColour(float r, float g, float b) {
        this.fadeRed = r;
        this.fadeGreen = g;
        this.fadeBlue = b;
    }

    public void setFacing(float yaw, float pitch) {
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public void setTargetPosition(double x, double y, double z) {
    }

    public void setTargetVelocity(double vx, double vy, double vz) {
    }

    public void setTargetEntity(Entity target) {
    }

    public void setLength(double length) {
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    protected int m_6355_(float f) {
        return this.shaded ? super.m_6355_(f) : 0xF000F0;
    }

    public void m_5744_(@NotNull VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Entity viewer = camera.m_90592_();
        this.updateEntityLinking(tickDelta);
        if (Float.isNaN(this.yaw) || Float.isNaN(this.pitch)) {
            super.m_5744_(vertexConsumer, camera, tickDelta);
        } else {
            float degToRadFactor = (float)Math.PI / 180;
            float rotationX = Mth.m_14089_((float)(this.yaw * degToRadFactor));
            float rotationZ = Mth.m_14031_((float)(this.yaw * degToRadFactor));
            float rotationY = Mth.m_14089_((float)(this.pitch * degToRadFactor));
            float rotationYZ = -rotationZ * Mth.m_14031_((float)(this.pitch * degToRadFactor));
            float rotationXY = rotationX * Mth.m_14031_((float)(this.pitch * degToRadFactor));
            this.drawParticle(vertexConsumer, camera, tickDelta, rotationX, rotationY, rotationZ, rotationYZ, rotationXY);
        }
    }

    protected void drawParticle(VertexConsumer buffer, Camera camera, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        Vec3 vec3 = camera.m_90583_();
        float s = this.adjustQuadSize ? 0.1f : 1.0f;
        float f4 = s * this.m_5902_(partialTicks);
        float f = this.m_5970_();
        float f1 = this.m_5952_();
        float f2 = this.m_5951_();
        float f3 = this.m_5950_();
        float f5 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f6 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f7 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        int i = this.m_6355_(partialTicks);
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        Vec3[] avec3 = new Vec3[]{new Vec3((double)(-rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(-rotationYZ * f4 - rotationX * f4)), new Vec3((double)(-rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(-rotationYZ * f4 + rotationXZ * f4)), new Vec3((double)(rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(rotationYZ * f4 + rotationXZ * f4)), new Vec3((double)(rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(rotationYZ * f4 - rotationXZ * f4))};
        if (this.angle != 0.0f) {
            float f8 = this.angle + (this.angle - this.f_107204_) * partialTicks;
            float f9 = Mth.m_14089_((float)(f8 * 0.5f));
            float f10 = Mth.m_14031_((float)(f8 * 0.5f)) * camera.m_253121_().x();
            float f11 = Mth.m_14031_((float)(f8 * 0.5f)) * camera.m_253121_().y();
            float f12 = Mth.m_14031_((float)(f8 * 0.5f)) * camera.m_253121_().z();
            Vec3 vec3d = new Vec3((double)f10, (double)f11, (double)f12);
            for (int l = 0; l < 4; ++l) {
                avec3[l] = vec3d.m_82490_(2.0 * avec3[l].m_82526_(vec3d)).m_82549_(avec3[l].m_82490_((double)(f9 * f9) - vec3d.m_82526_(vec3d))).m_82549_(vec3d.m_82537_(avec3[l]).m_82490_((double)(2.0f * f9)));
            }
        }
        buffer.m_5483_((double)f5 + avec3[0].f_82479_, (double)f6 + avec3[0].f_82480_, (double)f7 + avec3[0].f_82481_).m_7421_(f1, f3).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_7120_(j, k).m_5752_();
        buffer.m_5483_((double)f5 + avec3[1].f_82479_, (double)f6 + avec3[1].f_82480_, (double)f7 + avec3[1].f_82481_).m_7421_(f1, f2).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_7120_(j, k).m_5752_();
        buffer.m_5483_((double)f5 + avec3[2].f_82479_, (double)f6 + avec3[2].f_82480_, (double)f7 + avec3[2].f_82481_).m_7421_(f, f2).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_7120_(j, k).m_5752_();
        buffer.m_5483_((double)f5 + avec3[3].f_82479_, (double)f6 + avec3[3].f_82480_, (double)f7 + avec3[3].f_82481_).m_7421_(f, f3).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_7120_(j, k).m_5752_();
    }

    protected void updateEntityLinking(float partialTicks) {
        if (this.entity != null) {
            this.f_107212_ = this.f_107212_ + this.entity.f_19854_ - this.entity.m_20185_() - this.relativeMotionX * (double)(1.0f - partialTicks);
            this.f_107213_ = this.f_107213_ + this.entity.f_19855_ - this.entity.m_20186_() - this.relativeMotionY * (double)(1.0f - partialTicks);
            this.f_107214_ = this.f_107214_ + this.entity.f_19856_ - this.entity.m_20189_() - this.relativeMotionZ * (double)(1.0f - partialTicks);
        }
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.f_107219_ && this.f_107218_) {
            this.f_107215_ /= (double)0.7f;
            this.f_107217_ /= (double)0.7f;
        }
        if (this.entity != null || this.radius > 0.0) {
            double x = this.relativeX;
            double y = this.relativeY;
            double z = this.relativeZ;
            if (this.entity != null) {
                if (!this.entity.m_6084_()) {
                    this.m_107274_();
                } else {
                    x += this.entity.m_20185_();
                    y += this.entity.m_20186_();
                    z += this.entity.m_20189_();
                }
            }
            if (this.radius > 0.0) {
                this.angle += (float)this.speed;
                x += this.radius * (double)(-Mth.m_14089_((float)this.angle));
                z += this.radius * (double)Mth.m_14031_((float)this.angle);
            }
            this.m_107264_(x, y, z);
            this.relativeX += this.relativeMotionX;
            this.relativeY += this.relativeMotionY;
            this.relativeZ += this.relativeMotionZ;
        }
        float ageFraction = (float)this.f_107224_ / (float)this.f_107225_;
        this.f_107227_ = this.initialRed + (this.fadeRed - this.initialRed) * ageFraction;
        this.f_107228_ = this.initialGreen + (this.fadeGreen - this.initialGreen) * ageFraction;
        this.f_107229_ = this.initialBlue + (this.fadeBlue - this.initialBlue) * ageFraction;
        if (this.f_107219_) {
            double searchRadius;
            List<Entity> nearbyEntities;
            if (this.f_107215_ == 0.0 && this.prevVelX != 0.0) {
                this.f_107216_ *= 0.2;
                this.f_107217_ *= 0.2;
                this.f_107216_ += (this.random.nextDouble() * 2.0 - 1.0) * this.prevVelX * 0.2;
                this.f_107217_ += (this.random.nextDouble() * 2.0 - 1.0) * this.prevVelX * 0.2;
            }
            if (this.f_107216_ == 0.0 && this.prevVelY != 0.0) {
                this.f_107215_ *= 0.2;
                this.f_107217_ *= 0.2;
                this.f_107215_ += (this.random.nextDouble() * 2.0 - 1.0) * this.prevVelY * 0.2;
                this.f_107217_ += (this.random.nextDouble() * 2.0 - 1.0) * this.prevVelY * 0.2;
            }
            if (this.f_107217_ == 0.0 && this.prevVelZ != 0.0) {
                this.f_107215_ *= 0.2;
                this.f_107216_ *= 0.2;
                this.f_107215_ += (this.random.nextDouble() * 2.0 - 1.0) * this.prevVelZ * 0.2;
                this.f_107216_ += (this.random.nextDouble() * 2.0 - 1.0) * this.prevVelZ * 0.2;
            }
            if ((nearbyEntities = EntityUtil.getEntitiesWithinRadius(searchRadius = 20.0, this.f_107212_, this.f_107213_, this.f_107214_, (Level)this.f_107208_, Entity.class)).stream().anyMatch(e -> e instanceof ICustomHitbox && ((ICustomHitbox)e).calculateIntercept(new Vec3(this.f_107212_, this.f_107213_, this.f_107214_), new Vec3(this.f_107212_, this.f_107213_, this.f_107214_), 0.0f) != null)) {
                this.m_107274_();
            }
        }
        this.prevVelX = this.f_107215_;
        this.prevVelY = this.f_107216_;
        this.prevVelZ = this.f_107217_;
        if (this.updateTextureOnTick) {
            this.m_108339_(this.spriteSet);
        }
    }

    public void m_6257_(double dx, double dy, double dz) {
        double d0 = dx;
        double d1 = dy;
        double d2 = dz;
        if (this.f_107219_ && (dx != 0.0 || dy != 0.0 || dz != 0.0) && dx * dx + dy * dy + dz * dz < Mth.m_144952_((double)100.0)) {
            Vec3 vec3 = Entity.m_198894_(null, (Vec3)new Vec3(dx, dy, dz), (AABB)this.m_107277_(), (Level)this.f_107208_, List.of());
            dx = vec3.f_82479_;
            dy = vec3.f_82480_;
            dz = vec3.f_82481_;
        }
        if (dx != 0.0 || dy != 0.0 || dz != 0.0) {
            this.m_107259_(this.m_107277_().m_82386_(dx, dy, dz));
            this.m_107275_();
        }
        boolean bl = this.f_107218_ = d1 != dy && d1 < 0.0;
        if (d0 != dx) {
            this.f_107215_ = 0.0;
        }
        if (d1 != dy) {
            this.f_107216_ = 0.0;
        }
        if (d2 != dz) {
            this.f_107217_ = 0.0;
        }
    }
}

