/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.client.util;

import com.binaris.wizardry.api.client.util.GlyphClientHandler;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.util.SpellUtil;
import com.binaris.wizardry.client.gui.screens.SpellBookScreen;
import com.binaris.wizardry.content.data.SpellGlyphData;
import com.binaris.wizardry.core.mixin.accessor.MerchantMenuAccessor;
import com.binaris.wizardry.core.networking.s2c.SpellGlyphPacketS2C;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.Spells;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MerchantContainer;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffers;

public class ClientUtils {
    public static boolean isFirstPerson(Entity entity) {
        return entity == Minecraft.m_91087_().m_91288_() && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON;
    }

    public static boolean shouldDisplayDiscovered(Spell spell, @Nullable ItemStack stack) {
        MerchantMenu merchantMenu;
        MerchantContainer tradeContainer;
        MerchantOffers recipes;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        if (Minecraft.m_91087_().f_91080_ instanceof MerchantScreen && (recipes = ((MerchantMenu)((MerchantScreen)Minecraft.m_91087_().f_91080_).m_6262_()).m_40075_()).stream().anyMatch(r -> r.m_45368_() == stack)) {
            return true;
        }
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof MerchantMenu && (tradeContainer = ((MerchantMenuAccessor)(merchantMenu = (MerchantMenu)abstractContainerMenu)).getTradeContainer()).m_8020_(2) == stack) {
            return true;
        }
        if (player.m_7500_()) {
            return true;
        }
        return Services.OBJECT_DATA.getSpellManagerData((Player)player).hasSpellBeenDiscovered(spell);
    }

    public static LocalPlayer getPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static void handleGlyphDataPacket(SpellGlyphPacketS2C message) {
        SpellGlyphData data = GlyphClientHandler.INSTANCE.getGlyphData();
        data.randomNames = new HashMap<Spell, String>();
        data.randomDescriptions = new HashMap<Spell, String>();
        for (Spell spell : Services.REGISTRY_UTIL.getSpells()) {
            ResourceLocation spellId = spell.getLocation();
            String name = message.getNames().get(spellId);
            String description = message.getDescriptions().get(spellId);
            if (name != null) {
                data.randomNames.put(spell, name);
            }
            if (description == null) continue;
            data.randomDescriptions.put(spell, description);
        }
    }

    public static Component getScrollDisplayName(ItemStack scroll) {
        Spell spell = SpellUtil.getSpell(scroll);
        boolean discovered = ClientUtils.shouldDisplayDiscovered(spell, scroll);
        Component name = discovered ? spell.getDescriptionFormatted() : SpellGlyphData.getGlyphNameFormatted(spell, GlyphClientHandler.INSTANCE.getGlyphData());
        return Component.m_237110_((String)"item.ebwizardry.scroll", (Object[])new Object[]{name});
    }

    public static Component getBookDisplayName(ItemStack book) {
        Spell spell = SpellUtil.getSpell(book);
        if (spell == Spells.NONE) {
            return Component.m_237115_((String)"item.ebwizardry.spell_book.empty");
        }
        boolean discovered = ClientUtils.shouldDisplayDiscovered(spell, book);
        Component name = discovered ? spell.getDescriptionFormatted() : SpellGlyphData.getGlyphNameFormatted(spell, GlyphClientHandler.INSTANCE.getGlyphData());
        return Component.m_237110_((String)"item.ebwizardry.spell_book", (Object[])new Object[]{name});
    }

    public static void openSpellBook(ItemStack stack) {
        Minecraft.m_91087_().m_91152_((Screen)new SpellBookScreen(stack));
    }
}

