/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.data;

import com.binaris.wizardry.api.content.data.Persistence;
import java.util.function.BiFunction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public interface ISpellVar<T> {
    public T update(Player var1, T var2);

    public boolean isPersistent(boolean var1);

    public boolean isSynced();

    public void write(FriendlyByteBuf var1, T var2);

    public T read(FriendlyByteBuf var1);

    default public boolean canPurge(Player player, T value) {
        return false;
    }

    public static class SpellVar<T>
    implements ISpellVar<T> {
        private final Persistence persistence;
        private BiFunction<Player, T, T> ticker = (p, t) -> t;

        public SpellVar(Persistence persistence) {
            this.persistence = persistence;
        }

        public SpellVar<T> withTicker(BiFunction<Player, T, T> ticker) {
            this.ticker = ticker;
            return this;
        }

        @Override
        public T update(Player player, T value) {
            return this.ticker.apply(player, (Player)value);
        }

        @Override
        public boolean isPersistent(boolean respawn) {
            return respawn ? this.persistence.persistsOnRespawn() : this.persistence.persistsOnDimensionChange();
        }

        @Override
        public boolean isSynced() {
            return false;
        }

        @Override
        public void write(FriendlyByteBuf buf, T value) {
        }

        @Override
        public T read(FriendlyByteBuf buf) {
            return null;
        }
    }
}

