/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.data;

import com.binaris.wizardry.api.content.data.ISpellVar;
import com.binaris.wizardry.api.content.data.Persistence;
import com.binaris.wizardry.api.content.util.NBTExtras;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public interface IStoredSpellVar<T>
extends ISpellVar<T> {
    public void write(CompoundTag var1, T var2);

    public T read(CompoundTag var1);

    public static class StoredSpellVar<T, E extends Tag>
    implements IStoredSpellVar<T> {
        private final String key;
        private final Persistence persistence;
        private final Function<T, E> serializer;
        private final Function<E, T> deserializer;
        private boolean synced;
        private BiFunction<Player, T, T> ticker = (p, t) -> t;

        public StoredSpellVar(String key, Function<T, E> serializer, Function<E, T> deserializer, Persistence persistence) {
            this.key = key;
            this.serializer = serializer;
            this.deserializer = deserializer;
            this.persistence = persistence;
        }

        public static StoredSpellVar<Byte, ByteTag> ofByte(String key, Persistence persistence) {
            return new StoredSpellVar<Byte, ByteTag>(key, ByteTag::m_128266_, ByteTag::m_7063_, persistence);
        }

        public static StoredSpellVar<Boolean, ByteTag> ofBoolean(String key, Persistence persistence) {
            return new StoredSpellVar<Boolean, ByteTag>(key, b -> ByteTag.m_128266_((byte)((byte)(b != false ? 1 : 0))), t -> t.m_7063_() == 1, persistence);
        }

        public static StoredSpellVar<Integer, IntTag> ofInt(String key, Persistence persistence) {
            return new StoredSpellVar<Integer, IntTag>(key, IntTag::m_128679_, IntTag::m_7047_, persistence);
        }

        public static StoredSpellVar<int[], IntArrayTag> ofIntArray(String key, Persistence persistence) {
            return new StoredSpellVar<int[], IntArrayTag>(key, IntArrayTag::new, IntArrayTag::m_128648_, persistence);
        }

        public static StoredSpellVar<Float, FloatTag> ofFloat(String key, Persistence persistence) {
            return new StoredSpellVar<Float, FloatTag>(key, FloatTag::m_128566_, FloatTag::m_7057_, persistence);
        }

        public static StoredSpellVar<Double, DoubleTag> ofDouble(String key, Persistence persistence) {
            return new StoredSpellVar<Double, DoubleTag>(key, DoubleTag::m_128500_, DoubleTag::m_7061_, persistence);
        }

        public static StoredSpellVar<Short, ShortTag> ofShort(String key, Persistence persistence) {
            return new StoredSpellVar<Short, ShortTag>(key, ShortTag::m_129258_, ShortTag::m_7053_, persistence);
        }

        public static StoredSpellVar<Long, LongTag> ofLong(String key, Persistence persistence) {
            return new StoredSpellVar<Long, LongTag>(key, LongTag::m_128882_, LongTag::m_7046_, persistence);
        }

        public static StoredSpellVar<String, StringTag> ofString(String key, Persistence persistence) {
            return new StoredSpellVar<String, StringTag>(key, StringTag::m_129297_, StringTag::m_7916_, persistence);
        }

        public static StoredSpellVar<BlockPos, CompoundTag> ofBlockPos(String key, Persistence persistence) {
            return new StoredSpellVar<BlockPos, CompoundTag>(key, NbtUtils::m_129224_, NbtUtils::m_129239_, persistence);
        }

        public static StoredSpellVar<UUID, IntArrayTag> ofUUID(String key, Persistence persistence) {
            return new StoredSpellVar<UUID, IntArrayTag>(key, NbtUtils::m_129226_, NbtUtils::m_129233_, persistence);
        }

        public static StoredSpellVar<CompoundTag, CompoundTag> ofNBT(String key, Persistence persistence) {
            return new StoredSpellVar<CompoundTag, CompoundTag>(key, t -> t, t -> t, persistence);
        }

        public StoredSpellVar<T, E> withTicker(BiFunction<Player, T, T> ticker) {
            this.ticker = ticker;
            return this;
        }

        public StoredSpellVar<T, E> setSynced() {
            this.synced = true;
            return this;
        }

        @Override
        public void write(CompoundTag nbt, T value) {
            if (value != null) {
                NBTExtras.storeTagSafely(nbt, this.key, (Tag)this.serializer.apply(value));
            }
        }

        @Override
        public T read(CompoundTag nbt) {
            return nbt.m_128441_(this.key) ? (T)this.deserializer.apply(nbt.m_128423_(this.key)) : null;
        }

        @Override
        public T update(Player player, T value) {
            return this.ticker.apply(player, (Player)value);
        }

        @Override
        public boolean isPersistent(boolean respawn) {
            return respawn ? this.persistence.persistsOnRespawn() : this.persistence.persistsOnDimensionChange();
        }

        @Override
        public boolean isSynced() {
            return this.synced;
        }

        @Override
        public void write(FriendlyByteBuf buf, T value) {
            if (!this.synced) {
                return;
            }
            CompoundTag nbt = new CompoundTag();
            this.write(nbt, value);
            buf.m_130079_(nbt);
        }

        @Override
        public T read(FriendlyByteBuf buf) {
            if (!this.synced) {
                return null;
            }
            CompoundTag nbt = buf.m_130260_();
            return nbt != null ? (T)this.read(nbt) : null;
        }
    }
}

