/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.entity.construct;

import com.binaris.wizardry.api.content.item.ISpellCastingItem;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.core.AllyDesignation;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MagicConstructEntity
extends Entity
implements OwnableEntity {
    public int lifetime = 600;
    public float damageMultiplier = 1.0f;
    private UUID casterUUID;

    public MagicConstructEntity(EntityType<?> type, Level world) {
        super(type, world);
        this.f_19794_ = true;
    }

    @NotNull
    public InteractionResult m_7111_(@NotNull Player player, @NotNull Vec3 vec3, @NotNull InteractionHand hand) {
        if (this.lifetime == -1 && this.getCaster() == player && player.m_6144_() && player.m_21205_().m_41720_() instanceof ISpellCastingItem) {
            this.despawn();
            return InteractionResult.SUCCESS;
        }
        return super.m_7111_(player, vec3, hand);
    }

    public void despawn() {
        this.m_146870_();
    }

    public void m_8119_() {
        if (this.f_19797_ > this.lifetime && this.lifetime != -1) {
            this.m_146870_();
        }
        super.m_8119_();
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compoundTag) {
        if (compoundTag.m_128441_("casterUUID")) {
            this.casterUUID = compoundTag.m_128342_("casterUUID");
        }
        this.lifetime = compoundTag.m_128451_("lifetime");
        this.damageMultiplier = compoundTag.m_128457_("damageMultiplier");
    }

    protected void m_7380_(CompoundTag compoundTag) {
        if (this.casterUUID != null) {
            compoundTag.m_128362_("casterUUID", this.casterUUID);
        }
        compoundTag.m_128405_("lifetime", this.lifetime);
        compoundTag.m_128350_("damageMultiplier", this.damageMultiplier);
    }

    @Nullable
    public UUID m_21805_() {
        return this.casterUUID;
    }

    @Nullable
    public LivingEntity m_269323_() {
        return this.getCaster();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity = EntityUtil.getEntityByUUID(this.m_9236_(), this.m_21805_());
        if (entity != null && !(entity instanceof LivingEntity)) {
            entity = null;
        }
        return (LivingEntity)entity;
    }

    public void setCaster(@Nullable LivingEntity caster) {
        this.casterUUID = caster == null ? null : caster.m_20148_();
    }

    public boolean isValidTarget(Entity target) {
        return AllyDesignation.isValidTarget((Entity)this.getCaster(), target);
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }
}

