/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.entity.projectile;

import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.api.content.util.RayTracer;
import com.binaris.wizardry.core.AllyDesignation;
import com.binaris.wizardry.core.integrations.accessories.EBAccessoriesIntegration;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class MagicArrowEntity
extends AbstractArrow {
    public static final double LAUNCH_Y_OFFSET = 0.3;
    public static final float FORWARD_OFFSET = 0.1f;
    public static final int SEEKING_TIME = 15;
    public float damageMultiplier = 1.0f;
    protected int ticksInGround;
    protected int ticksInAir;

    public MagicArrowEntity(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
    }

    public void aim(LivingEntity caster, float speed) {
        if (this.m_19749_() == null) {
            this.m_5602_((Entity)caster);
        }
        Vec3 lookVector = caster.m_20154_();
        this.m_19890_(caster.f_19854_ + lookVector.f_82479_ * (double)0.1f, caster.m_20186_() + (double)caster.m_6972_((Pose)caster.m_20089_()).f_20378_ - 0.3, caster.f_19856_ + lookVector.f_82481_ * (double)0.1f, caster.m_146908_(), caster.m_146909_());
        this.f_19854_ -= (double)(Mth.m_14089_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * 0.16f);
        this.f_19855_ -= (double)0.1f;
        this.f_19856_ -= (double)(Mth.m_14089_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * 0.16f);
        this.m_6034_(this.f_19854_, this.f_19855_, this.f_19856_);
        double motionX = -Mth.m_14031_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(this.m_146909_() / 180.0f * (float)Math.PI));
        double motionY = -Mth.m_14031_((float)(this.m_146909_() / 180.0f * (float)Math.PI));
        double motionZ = Mth.m_14089_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(this.m_146909_() / 180.0f * (float)Math.PI));
        this.m_6686_(motionX, motionY, motionZ, speed * 1.5f, 1.0f);
    }

    public void aim(LivingEntity caster, Entity target, float speed, float aimingError) {
        if (this.m_19749_() == null) {
            this.m_5602_((Entity)caster);
        }
        this.f_19855_ = caster.f_19855_ + (double)caster.m_6972_((Pose)caster.m_20089_()).f_20378_ * (double)0.85f - 0.3;
        double dx = target.f_19854_ - caster.f_19854_;
        double dy = !this.m_20068_() ? target.f_19855_ + (double)(target.m_6972_((Pose)caster.m_20089_()).f_20378_ / 3.0f) - this.f_19855_ : target.f_19855_ + (double)(target.m_6972_((Pose)caster.m_20089_()).f_20378_ / 2.0f) - this.f_19855_;
        double dz = target.f_19856_ - caster.f_19856_;
        double horizontalDistance = Mth.m_14116_((float)((float)(dx * dx + dz * dz)));
        if (horizontalDistance >= 1.0E-7) {
            float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
            float pitch = (float)(-(Math.atan2(dy, horizontalDistance) * 180.0 / Math.PI));
            double dxNormalised = dx / horizontalDistance;
            double dzNormalised = dz / horizontalDistance;
            this.m_19890_(caster.f_19854_ + dxNormalised, this.f_19855_, caster.f_19856_ + dzNormalised, yaw, pitch);
            float bulletDropCompensation = !this.m_20068_() ? (float)horizontalDistance * 0.2f : 0.0f;
            this.m_6686_(dx, dy + (double)bulletDropCompensation, dz, speed, aimingError);
        }
    }

    protected void m_5790_(@NotNull EntityHitResult hitResult) {
        Entity entity;
        Entity entity2 = hitResult.m_82443_();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity2;
        if (MagicDamageSource.isEntityImmune(this.getDamageType(), (Entity)target)) {
            this.m_146870_();
            return;
        }
        DamageSource damageSource = this.m_19749_() == null ? MagicDamageSource.causeDirectMagicDamage((Entity)this, this.getDamageType()) : MagicDamageSource.causeIndirectMagicDamage((Entity)this, this.m_19749_(), this.getDamageType());
        target.m_6469_(damageSource, (float)this.getDamage() * this.damageMultiplier);
        if (this.m_150123_() > 0) {
            double knockback = Math.max(0.0, 1.0 - target.m_21133_(Attributes.f_22278_));
            Vec3 vecKnockback = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.m_150123_() * 0.6 * knockback);
            if (vecKnockback.m_82556_() > 0.0) {
                target.m_5997_(vecKnockback.f_82479_, 0.1, vecKnockback.f_82481_);
            }
        }
        if (!this.m_9236_().f_46443_ && (entity = this.m_19749_()) instanceof LivingEntity) {
            LivingEntity arrowOwner = (LivingEntity)entity;
            EnchantmentHelper.m_44823_((LivingEntity)target, (Entity)arrowOwner);
            EnchantmentHelper.m_44896_((LivingEntity)arrowOwner, (Entity)target);
        }
        this.m_146870_();
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("ticksInAir", this.ticksInAir);
        compound.m_128405_("ticksInGround", this.ticksInGround);
        compound.m_128350_("damageMultiplier", this.damageMultiplier);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.ticksInAir = compound.m_128451_("ticksInAir");
        this.ticksInGround = compound.m_128451_("ticksInGround");
        this.damageMultiplier = compound.m_128457_("damageMultiplier");
    }

    public abstract double getDamage();

    public abstract int getLifetime();

    public ResourceKey<DamageType> getDamageType() {
        return EBDamageSources.SORCERY;
    }

    public abstract ResourceLocation getTexture();

    @Deprecated
    public boolean doDeceleration() {
        return true;
    }

    @Deprecated
    public boolean doOverpenetration() {
        return false;
    }

    public float getSeekingStrength() {
        Player player;
        Entity entity = this.m_19749_();
        return entity instanceof Player && EBAccessoriesIntegration.isEquipped(player = (Player)entity, EBItems.RING_SEEKING.get()) ? 2 : 0;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getLifetime() >= 0 && this.f_19797_ >= this.getLifetime()) {
            this.m_146870_();
        }
        if (this.f_36703_) {
            ++this.ticksInGround;
            this.tickInGround();
        } else {
            ++this.ticksInAir;
            this.ticksInAir();
        }
        if (this.getSeekingStrength() <= 0.0f) {
            return;
        }
        HitResult hit = RayTracer.rayTrace(this.m_9236_(), (Entity)this, this.m_20182_(), this.m_20182_().m_82549_(this.m_20184_().m_82490_(15.0)), this.getSeekingStrength(), false, LivingEntity.class, RayTracer.ignoreEntityFilter(null));
        if (hit instanceof EntityHitResult) {
            EntityHitResult entityHit = (EntityHitResult)hit;
            Entity entity = this.m_19749_();
            if (entity instanceof LivingEntity) {
                LivingEntity entity2;
                LivingEntity owner = (LivingEntity)entity;
                entity = entityHit.m_82443_();
                if (entity instanceof LivingEntity && AllyDesignation.isValidTarget((Entity)owner, (Entity)(entity2 = (LivingEntity)entity))) {
                    Vec3 direction = new Vec3(entity2.f_19854_, entity2.f_19855_ + (double)(entity2.m_6972_((Pose)entity2.m_20089_()).f_20378_ / 2.0f), entity2.f_19856_).m_82546_(this.m_20182_()).m_82541_().m_82490_(this.m_20184_().m_82553_());
                    this.m_20256_(this.m_20184_().m_82549_(direction.m_82546_(this.m_20184_()).m_82490_(0.13333333333333333)));
                }
            }
        }
    }

    public void tickInGround() {
    }

    public void ticksInAir() {
    }

    protected boolean m_142470_(@NotNull Player player) {
        return false;
    }

    @NotNull
    protected SoundEvent m_7239_() {
        return SoundEvents.f_271165_;
    }
}

