/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.entity.projectile;

import com.binaris.wizardry.api.content.util.RayTracer;
import com.binaris.wizardry.core.AllyDesignation;
import com.binaris.wizardry.core.integrations.accessories.EBAccessoriesIntegration;
import com.binaris.wizardry.setup.registries.EBItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class MagicProjectileEntity
extends ThrowableItemProjectile {
    public static final double LAUNCH_Y_OFFSET = 0.3;
    public static final float FORWARD_OFFSET = 0.8f;
    public static final int SEEKING_TIME = 15;
    public float damageMultiplier = 1.0f;

    public MagicProjectileEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public MagicProjectileEntity(EntityType<? extends ThrowableItemProjectile> entityType, LivingEntity livingEntity, Level level) {
        super(entityType, livingEntity, level);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getLifeTime() >= 0 && this.f_19797_ > this.getLifeTime()) {
            this.m_146870_();
        }
        if (this.getSeekingStrength() <= 0.0f) {
            return;
        }
        HitResult hit = RayTracer.rayTrace(this.m_9236_(), (Entity)this, this.m_20182_(), this.m_20182_().m_82549_(this.m_20184_().m_82490_(15.0)), this.getSeekingStrength(), false, LivingEntity.class, RayTracer.ignoreEntityFilter(null));
        if (hit instanceof EntityHitResult) {
            EntityHitResult entityHit = (EntityHitResult)hit;
            Entity entity = this.m_19749_();
            if (entity instanceof LivingEntity) {
                LivingEntity entity2;
                LivingEntity owner = (LivingEntity)entity;
                entity = entityHit.m_82443_();
                if (entity instanceof LivingEntity && AllyDesignation.isValidTarget((Entity)owner, (Entity)(entity2 = (LivingEntity)entity))) {
                    Vec3 direction = new Vec3(entity2.f_19854_, entity2.f_19855_ + (double)(entity2.m_6972_((Pose)entity2.m_20089_()).f_20378_ / 2.0f), entity2.f_19856_).m_82546_(this.m_20182_()).m_82541_().m_82490_(this.m_20184_().m_82553_());
                    this.m_20256_(this.m_20184_().m_82549_(direction.m_82546_(this.m_20184_()).m_82490_(0.13333333333333333)));
                }
            }
        }
    }

    public void aim(LivingEntity caster, float speed) {
        Vec3 lookVector = caster.m_20154_();
        this.m_6034_(caster.f_19854_ + lookVector.f_82479_ * (double)0.8f, caster.f_19855_ + (double)caster.m_20192_() - 0.3, caster.f_19856_ + lookVector.f_82481_ * (double)0.8f);
        this.m_37251_((Entity)caster, caster.m_146909_(), caster.m_146908_(), 0.0f, speed, 1.0f);
        this.m_5602_((Entity)caster);
    }

    public float getSeekingStrength() {
        Player player;
        Entity entity = this.m_19749_();
        return entity instanceof Player && EBAccessoriesIntegration.isEquipped(player = (Player)entity, EBItems.RING_SEEKING.get()) ? 2 : 0;
    }

    public void aim(LivingEntity caster, Entity target, float speed, float aimingError) {
        this.m_5602_((Entity)caster);
        this.f_19855_ = caster.f_19855_ + (double)caster.m_6972_((Pose)caster.m_20089_()).f_20378_ * (double)0.85f - 0.3;
        double dx = target.f_19854_ - caster.f_19854_;
        double dy = !this.m_20068_() ? target.f_19855_ + (double)(target.m_6972_((Pose)caster.m_20089_()).f_20378_ / 3.0f) - this.f_19855_ : target.f_19855_ + (double)(target.m_6972_((Pose)caster.m_20089_()).f_20378_ / 2.0f) - this.f_19855_;
        double dz = target.f_19856_ - caster.f_19856_;
        double horizontalDistance = Mth.m_14116_((float)((float)(dx * dx + dz * dz)));
        if (horizontalDistance >= 1.0E-7) {
            float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
            float pitch = (float)(-(Math.atan2(dy, horizontalDistance) * 180.0 / Math.PI));
            double dxNormalised = dx / horizontalDistance;
            double dzNormalised = dz / horizontalDistance;
            this.m_19890_(caster.f_19854_ + dxNormalised, this.f_19855_, caster.f_19856_ + dzNormalised, yaw, pitch);
            float bulletDropCompensation = !this.m_20068_() ? (float)horizontalDistance * 0.2f : 0.0f;
            this.m_6686_(dx, dy + (double)bulletDropCompensation, dz, speed, aimingError);
        }
    }

    public void m_20258_(@NotNull CompoundTag tag) {
        super.m_20258_(tag);
        this.damageMultiplier = tag.m_128457_("damageMultiplier");
    }

    public boolean m_20223_(CompoundTag tag) {
        tag.m_128350_("damageMultiplier", this.damageMultiplier);
        return super.m_20223_(tag);
    }

    public int getLifeTime() {
        return -1;
    }
}

