/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.event;

import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.core.event.IWizardryEvent;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class SpellCastEvent
implements IWizardryEvent {
    private final Spell spell;
    private final SpellModifiers modifiers;
    private final Source source;
    @Nullable
    private final LivingEntity caster;
    private final Level world;
    private final double x;
    private final double y;
    private final double z;
    private final Direction direction;
    private boolean isCanceled;

    public SpellCastEvent(Source source, Spell spell, LivingEntity caster, SpellModifiers modifiers) {
        this.spell = spell;
        this.modifiers = modifiers;
        this.source = source;
        this.caster = caster;
        this.world = caster.m_9236_();
        this.x = Double.NaN;
        this.y = Double.NaN;
        this.z = Double.NaN;
        this.direction = null;
    }

    public SpellCastEvent(Source source, Spell spell, Level world, double x, double y, double z, Direction direction, SpellModifiers modifiers) {
        this.spell = spell;
        this.modifiers = modifiers;
        this.source = source;
        this.caster = null;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.direction = direction;
    }

    public Spell getSpell() {
        return this.spell;
    }

    public SpellModifiers getModifiers() {
        return this.modifiers;
    }

    public Source getSource() {
        return this.source;
    }

    @Nullable
    public LivingEntity getCaster() {
        return this.caster;
    }

    public Level getLevel() {
        return this.world;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    @Nullable
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void setCanceled(boolean cancel) {
        this.isCanceled = cancel;
    }

    public static enum Source {
        WAND,
        SCROLL,
        NPC,
        DISPENSER,
        OTHER,
        COMMAND;

    }

    public static class Finish
    extends SpellCastEvent {
        private final int ticksCasting;

        public Finish(Source source, Spell spell, LivingEntity caster, SpellModifiers modifiers, int ticks) {
            super(source, spell, caster, modifiers);
            this.ticksCasting = ticks;
        }

        public Finish(Source source, Spell spell, Level world, double x, double y, double z, Direction direction, SpellModifiers modifiers, int ticks) {
            super(source, spell, world, x, y, z, direction, modifiers);
            this.ticksCasting = ticks;
        }

        public int getTicksCasting() {
            return this.ticksCasting;
        }

        @Override
        public boolean canBeCanceled() {
            return false;
        }
    }

    public static class Tick
    extends SpellCastEvent {
        private final int ticksCasting;

        public Tick(Source source, Spell spell, LivingEntity caster, SpellModifiers modifiers, int ticks) {
            super(source, spell, caster, modifiers);
            this.ticksCasting = ticks;
        }

        public Tick(Source source, Spell spell, Level world, double x, double y, double z, Direction direction, SpellModifiers modifiers, int ticks) {
            super(source, spell, world, x, y, z, direction, modifiers);
            this.ticksCasting = ticks;
        }

        public int getTicksCasting() {
            return this.ticksCasting;
        }

        @Override
        public boolean canBeCanceled() {
            return true;
        }
    }

    public static class Post
    extends SpellCastEvent {
        public Post(Source source, Spell spell, LivingEntity caster, SpellModifiers modifiers) {
            super(source, spell, caster, modifiers);
        }

        public Post(Source source, Spell spell, Level world, double x, double y, double z, Direction direction, SpellModifiers modifiers) {
            super(source, spell, world, x, y, z, direction, modifiers);
        }

        @Override
        public boolean canBeCanceled() {
            return false;
        }
    }

    public static class Pre
    extends SpellCastEvent {
        public Pre(Source source, Spell spell, LivingEntity caster, SpellModifiers modifiers) {
            super(source, spell, caster, modifiers);
        }

        public Pre(Source source, Spell spell, Level world, double x, double y, double z, Direction direction, SpellModifiers modifiers) {
            super(source, spell, world, x, y, z, direction, modifiers);
        }

        @Override
        public boolean canBeCanceled() {
            return true;
        }
    }
}

