/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.item;

import com.binaris.wizardry.api.content.event.EBLivingDeathEvent;
import com.binaris.wizardry.api.content.event.EBLivingHurtEvent;
import com.binaris.wizardry.api.content.event.EBLivingTick;
import com.binaris.wizardry.api.content.event.SpellCastEvent;
import com.binaris.wizardry.core.IArtefactEffect;
import com.binaris.wizardry.core.integrations.accessories.EBAccessoriesIntegration;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtefactItem
extends Item {
    @Nullable
    private final IArtefactEffect effect;

    public ArtefactItem(Rarity rarity) {
        super(new Item.Properties().m_41487_(1).m_41497_(rarity));
        this.effect = null;
    }

    public ArtefactItem(Rarity rarity, @Nullable IArtefactEffect effect) {
        super(new Item.Properties().m_41487_(1).m_41497_(rarity));
        this.effect = effect;
    }

    public static void onArtifactTick(EBLivingTick event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        List<ItemStack> stacks = EBAccessoriesIntegration.getEquippedItems(player);
        stacks.stream().filter(stack -> {
            ArtefactItem artefact;
            Item patt2719$temp = stack.m_41720_();
            return patt2719$temp instanceof ArtefactItem && (artefact = (ArtefactItem)patt2719$temp).getEffect() != null;
        }).forEach(stack -> ((ArtefactItem)stack.m_41720_()).getEffect().onTick(event.getEntity(), event.getLevel(), (ItemStack)stack));
    }

    public static void onArtifactHurt(EBLivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        List<ItemStack> stacks = EBAccessoriesIntegration.getEquippedItems(player);
        stacks.stream().filter(stack -> {
            ArtefactItem artefact;
            Item patt3728$temp = stack.m_41720_();
            return patt3728$temp instanceof ArtefactItem && (artefact = (ArtefactItem)patt3728$temp).getEffect() != null;
        }).forEach(stack -> ((ArtefactItem)stack.m_41720_()).getEffect().onHurtEntity(event, (ItemStack)stack));
    }

    public static void onArtifactDeath(EBLivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        List<ItemStack> stacks = EBAccessoriesIntegration.getEquippedItems(player);
        stacks.stream().filter(stack -> {
            ArtefactItem artefact;
            Item patt4667$temp = stack.m_41720_();
            return patt4667$temp instanceof ArtefactItem && (artefact = (ArtefactItem)patt4667$temp).getEffect() != null;
        }).forEach(stack -> ((ArtefactItem)stack.m_41720_()).getEffect().onDeath(event, (ItemStack)stack));
    }

    public static void onArtifactPreCast(SpellCastEvent.Pre event) {
        LivingEntity livingEntity = event.getCaster();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        List<ItemStack> stacks = EBAccessoriesIntegration.getEquippedItems(player);
        stacks.stream().filter(stack -> {
            ArtefactItem artefact;
            Item patt5614$temp = stack.m_41720_();
            return patt5614$temp instanceof ArtefactItem && (artefact = (ArtefactItem)patt5614$temp).getEffect() != null;
        }).forEach(stack -> ((ArtefactItem)stack.m_41720_()).getEffect().onSpellPreCast(event, (ItemStack)stack));
    }

    public static void onArtifactPostCast(SpellCastEvent.Post event) {
        LivingEntity livingEntity = event.getCaster();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        List<ItemStack> stacks = EBAccessoriesIntegration.getEquippedItems(player);
        stacks.stream().filter(stack -> {
            ArtefactItem artefact;
            Item patt6569$temp = stack.m_41720_();
            return patt6569$temp instanceof ArtefactItem && (artefact = (ArtefactItem)patt6569$temp).getEffect() != null;
        }).forEach(stack -> ((ArtefactItem)stack.m_41720_()).getEffect().onSpellPostCast(event, (ItemStack)stack));
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> list, @NotNull TooltipFlag isAdvanced) {
        list.add((Component)Component.m_237115_((String)(this.m_5524_() + ".desc")).m_130940_(ChatFormatting.GRAY));
    }

    @Nullable
    public IArtefactEffect getEffect() {
        return this.effect;
    }
}

