/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.item;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface IManaStoringItem {
    public int getMana(ItemStack var1);

    public void setMana(ItemStack var1, int var2);

    public int getManaCapacity(ItemStack var1);

    default public boolean showManaInWorkbench(Player player, ItemStack stack) {
        return true;
    }

    default public void consumeMana(ItemStack stack, int mana, @Nullable LivingEntity wielder) {
        if (wielder instanceof Player && ((Player)wielder).m_7500_()) {
            return;
        }
        this.setMana(stack, Math.max(this.getMana(stack) - mana, 0));
    }

    default public void rechargeMana(ItemStack stack, int mana) {
        this.setMana(stack, Math.min(this.getMana(stack) + mana, this.getManaCapacity(stack)));
    }

    default public boolean isManaFull(ItemStack stack) {
        return this.getMana(stack) == this.getManaCapacity(stack);
    }

    default public boolean isManaEmpty(ItemStack stack) {
        return this.getMana(stack) == 0;
    }

    default public float getFullness(ItemStack stack) {
        return (float)this.getMana(stack) / (float)this.getManaCapacity(stack);
    }
}

