/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.spell;

import com.binaris.wizardry.core.platform.Services;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class Element {
    private final ChatFormatting color;
    private final int[] colors;
    private String descriptionId;
    private ResourceLocation location;
    private ResourceLocation icon;

    public Element(ChatFormatting colour, int ... colors) {
        this.color = colour;
        this.colors = colors;
    }

    public int[] getColors() {
        return this.colors;
    }

    public Component getDescriptionFormatted() {
        return Component.m_237115_((String)this.getOrCreateDescriptionId()).m_130940_(this.color);
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.m_137492_((String)"element", (ResourceLocation)Services.REGISTRY_UTIL.getElement(this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    protected ResourceLocation getOrCreateLocation() {
        if (this.location == null) {
            this.location = Services.REGISTRY_UTIL.getElement(this);
        }
        return this.location;
    }

    public ResourceLocation getLocation() {
        return this.getOrCreateLocation();
    }

    public final boolean is(ResourceLocation location) {
        return location.equals((Object)this.getLocation());
    }

    public final boolean is(String location) {
        return location.equals(this.getLocation().toString());
    }

    public String getName() {
        return this.getLocation().m_135815_();
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    public Component getWizardName() {
        return Component.m_237115_((String)(this.getDescriptionId() + ".wizard"));
    }

    public ResourceLocation getIconId() {
        if (this.icon == null) {
            this.icon = new ResourceLocation("ebwizardry", "textures/gui/container/element_icon_" + this.getOrCreateLocation().m_135815_() + ".png");
        }
        return this.icon;
    }
}

