/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.spell;

import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.NoneSpell;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellContext;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.core.ClientSpellSoundManager;
import com.binaris.wizardry.core.platform.Services;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class Spell {
    protected float volume = 1.0f;
    protected float pitch = 1.0f;
    protected float pitchVariation = 0.0f;
    private String descriptionId;
    private ResourceLocation location;
    private ResourceLocation icon;
    private SpellProperties properties = this.properties();
    private boolean ended;

    public abstract boolean cast(PlayerCastContext var1);

    public boolean cast(EntityCastContext ctx) {
        return false;
    }

    public boolean cast(LocationCastContext ctx) {
        return false;
    }

    public void endCast(CastContext cxt) {
        this.ended = true;
    }

    public void onCharge(CastContext ctx) {
    }

    public final boolean hasEnded() {
        return this.ended;
    }

    public boolean isInstantCast() {
        return true;
    }

    public boolean canCastByEntity() {
        return false;
    }

    public boolean canCastByLocation() {
        return false;
    }

    public final Boolean isEmpty() {
        return this instanceof NoneSpell;
    }

    public boolean requiresPacket() {
        return true;
    }

    public Component getDescriptionFormatted() {
        return Component.m_237115_((String)this.getOrCreateDescriptionId()).m_130940_(this.getElement().getColor());
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.m_137492_((String)"spell", (ResourceLocation)Services.REGISTRY_UTIL.getSpell(this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    protected ResourceLocation getOrCreateLocation() {
        if (this.location == null) {
            this.location = Services.REGISTRY_UTIL.getSpell(this);
        }
        return this.location;
    }

    public ResourceLocation getLocation() {
        return this.getOrCreateLocation();
    }

    public Component getDesc() {
        return Component.m_237115_((String)(this.getOrCreateDescriptionId() + ".desc"));
    }

    public ResourceLocation getIcon() {
        if (this.icon == null) {
            ResourceLocation location = this.getOrCreateLocation();
            this.icon = new ResourceLocation(location.m_135827_(), "textures/spells/" + location.m_135815_() + ".png");
        }
        return this.icon;
    }

    public final boolean is(ResourceLocation location) {
        return location.equals((Object)this.getLocation());
    }

    public final boolean is(String location) {
        return location.equals(this.getLocation().toString());
    }

    public final SpellProperties getProperties() {
        return this.properties;
    }

    public void setProperties(SpellProperties properties) {
        this.properties = properties;
    }

    @NotNull
    protected abstract SpellProperties properties();

    public final Spell assignProperties(SpellProperties properties) {
        this.properties = properties;
        return this;
    }

    public final <T> T property(SpellProperty<T> property) {
        return this.properties.get(property);
    }

    public final boolean is(Spell spell) {
        return spell.getDescriptionId().equals(this.descriptionId);
    }

    public int getCharge() {
        return this.properties.getChargeup();
    }

    public SpellType getType() {
        return this.properties.getType();
    }

    public SpellAction getAction() {
        return this.properties.getAction();
    }

    public Element getElement() {
        return this.properties.getElement();
    }

    public SpellTier getTier() {
        return this.properties.getTier();
    }

    public int getCost() {
        return this.properties.getCost();
    }

    public int getCooldown() {
        return this.properties.getCooldown();
    }

    public boolean isEnabled(SpellContext context) {
        return this.properties.isEnabledInContext(context);
    }

    public String toString() {
        return this.getLocation().toString();
    }

    public Spell soundValues(float volume, float pitch, float pitchVariation) {
        this.volume = volume;
        this.pitch = pitch;
        this.pitchVariation = pitchVariation;
        return this;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getPitchVariation() {
        return this.pitchVariation;
    }

    protected void playSound(Level world, LivingEntity entity, int castTicks, int duration) {
        if (!entity.m_20067_()) {
            this.playSound(world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), castTicks, duration);
        }
    }

    protected void playSound(Level world, Vec3 pos, int castTicks, int duration) {
        this.playSound(world, pos.f_82479_, pos.f_82480_, pos.f_82481_, castTicks, duration);
    }

    protected void playSound(Level world, double x, double y, double z, int ticksInUse, int duration) {
        SoundEvent sound = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(this.getLocation().m_135827_(), "spell." + this.getLocation().m_135815_()));
        world.m_6263_(null, x, y, z, sound, SoundSource.PLAYERS, this.getVolume(), this.getPitch() + this.getPitchVariation() * (world.f_46441_.m_188501_() - 0.5f));
    }

    protected final void playSoundLoop(Level world, LivingEntity entity, int ticksInUse) {
        if (ticksInUse == 0 && world.f_46443_) {
            ClientSpellSoundManager.playSpellSoundLoop(entity, this, this.getLoopSounds(), this.volume, this.pitch + this.pitchVariation * (world.f_46441_.m_188501_() - 0.5f));
        }
    }

    protected final void playSoundLoop(Level world, double x, double y, double z, int ticksInUse, int duration) {
        if (ticksInUse == 0 && world.f_46443_) {
            ClientSpellSoundManager.playSpellSoundLoop(world, x, y, z, this, this.getLoopSounds(), this.volume, this.pitch + this.pitchVariation * (world.f_46441_.m_188501_() - 0.5f), duration);
        }
    }

    protected SoundEvent[] getLoopSounds() {
        List<String> names = List.of("start", "loop", "end");
        return (SoundEvent[])names.stream().map(name -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(this.getLocation().m_135827_(), "spell." + this.getLocation().m_135815_() + "." + name))).toArray(SoundEvent[]::new);
    }
}

