/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.spell;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.spell.Spell;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SpellAction {
    public static final SpellAction POINT;
    public static SpellAction POINT_UP;
    public static SpellAction POINT_DOWN;
    public static SpellAction SUMMON;
    public static SpellAction THRUST;
    public static SpellAction IMBUE;
    public static SpellAction GRAPPLE;
    public static SpellAction NONE;
    static List<SpellAction> spellActions;
    public ResourceLocation location;

    public SpellAction(ResourceLocation location) {
        this.location = location;
        spellActions.add(this);
    }

    public static void register() {
    }

    @Nullable
    public static SpellAction get(ResourceLocation location) {
        for (SpellAction action : spellActions) {
            if (!action.location.equals((Object)location)) continue;
            return action;
        }
        return null;
    }

    public void renderArms(LivingEntity entity, HumanoidModel<?> model, InteractionHand hand) {
    }

    public boolean shouldRender(LivingEntity entity, Spell spell, ItemStack stack, InteractionHand hand) {
        return spell != null && spell.getAction() != NONE && entity.m_6117_();
    }

    static {
        spellActions = new ArrayList<SpellAction>();
        POINT = new SpellAction(WizardryMainMod.location("point")){

            @Override
            public void renderArms(LivingEntity entity, HumanoidModel<?> model, InteractionHand hand) {
                float pitch = (float)Math.toRadians(entity.m_146909_());
                float yaw = (float)Math.toRadians(entity.f_20885_ - entity.f_20883_);
                float x = -1.5707964f + pitch + 0.2f;
                float y = (hand == InteractionHand.MAIN_HAND ? -0.25f : 0.25f) + yaw;
                if (hand == InteractionHand.MAIN_HAND) {
                    model.f_102811_.m_171327_(x, y, 0.0f);
                } else {
                    model.f_102812_.m_171327_(x, y, 0.0f);
                }
            }
        };
        POINT_UP = new SpellAction(WizardryMainMod.location("point_up")){

            @Override
            public void renderArms(LivingEntity entity, HumanoidModel<?> model, InteractionHand hand) {
                if (hand == InteractionHand.MAIN_HAND) {
                    model.f_102811_.m_171327_(-2.2f, 0.2f, 0.0f);
                } else {
                    model.f_102812_.m_171327_(-2.2f, -0.2f, 0.0f);
                }
            }
        };
        POINT_DOWN = new SpellAction(WizardryMainMod.location("point_down")){

            @Override
            public void renderArms(LivingEntity entity, HumanoidModel<?> model, InteractionHand hand) {
                float tick = Math.abs(entity.m_21212_());
                float y = Math.min(0.4f + tick * 0.05f, 0.7f);
                if (hand == InteractionHand.MAIN_HAND) {
                    model.f_102811_.m_171327_(-0.2f, y, 0.0f);
                } else {
                    model.f_102812_.m_171327_(-0.2f, -y, 0.0f);
                }
            }
        };
        SUMMON = new SpellAction(WizardryMainMod.location("summon")){

            @Override
            public void renderArms(LivingEntity entity, HumanoidModel<?> model, InteractionHand hand) {
                float tick = Math.abs(entity.m_21212_());
                float x = -Math.min(0.4f + tick * 0.2f, 2.0f);
                model.f_102811_.m_171327_(x, 1.2f, 0.0f);
                model.f_102812_.m_171327_(x, -1.2f, 0.0f);
            }
        };
        IMBUE = new SpellAction(WizardryMainMod.location("imbue")){

            @Override
            public void renderArms(LivingEntity entity, HumanoidModel<?> model, InteractionHand hand) {
                InteractionHand opposite;
                float tick = Math.abs(entity.m_21212_());
                float z = Math.max(1.5f - tick * 0.1f, 0.8f);
                if (hand == InteractionHand.MAIN_HAND) {
                    model.f_102811_.m_171327_(-1.2f, -0.2f, z);
                } else {
                    model.f_102812_.m_171327_(-1.2f, 0.2f, -z);
                }
                InteractionHand interactionHand = opposite = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
                if (!entity.m_21120_(opposite).m_41619_()) {
                    if (hand == InteractionHand.OFF_HAND) {
                        model.f_102811_.m_171327_(-0.8f, 0.3f, 0.0f);
                    } else {
                        model.f_102812_.m_171327_(-0.8f, 0.3f, 0.0f);
                    }
                }
            }
        };
        THRUST = new SpellAction(WizardryMainMod.location("thrust")){

            @Override
            public void renderArms(LivingEntity entity, HumanoidModel<?> model, InteractionHand hand) {
                InteractionHand opposite;
                if (hand == InteractionHand.MAIN_HAND) {
                    model.f_102811_.m_171327_(-1.2f, -0.6f, 0.0f);
                } else {
                    model.f_102812_.m_171327_(-1.2f, 0.6f, 0.0f);
                }
                InteractionHand interactionHand = opposite = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
                if (entity.m_21120_(opposite).m_41619_()) {
                    if (opposite == InteractionHand.MAIN_HAND) {
                        model.f_102811_.m_171327_(-1.2f, -0.6f, 0.0f);
                    } else {
                        model.f_102812_.m_171327_(-1.2f, 0.6f, 0.0f);
                    }
                }
            }
        };
        GRAPPLE = new SpellAction(WizardryMainMod.location("grapple"));
        NONE = new SpellAction(WizardryMainMod.location("none"));
    }
}

