/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.spell;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum SpellContext {
    BOOK("book"),
    SCROLL("scroll"),
    WANDS("wands"),
    NPCS("npcs"),
    DISPENSERS("dispensers"),
    COMMANDS("commands"),
    TREASURE("treasure"),
    TRADES("trades"),
    LOOTING("looting");

    private final String key;

    private SpellContext(String key) {
        this.key = key;
    }

    public static SpellContext fromKey(String key) {
        if (key == null) {
            return null;
        }
        for (SpellContext context : SpellContext.values()) {
            if (!context.key.equals(key)) continue;
            return context;
        }
        return null;
    }

    public static Map<String, Boolean> createDefaultMap() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (SpellContext context : SpellContext.values()) {
            map.put(context.key, true);
        }
        return map;
    }

    public static String[] getAllKeys() {
        return (String[])Arrays.stream(SpellContext.values()).map(SpellContext::getKey).toArray(String[]::new);
    }

    public static boolean isValidKey(String key) {
        return SpellContext.fromKey(key) != null;
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        return this.key;
    }
}

