/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.spell;

import com.binaris.wizardry.core.platform.Services;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;

public class SpellTier {
    public final int maxCharge;
    public final int level;
    public final int upgradeLimit;
    public final int weight;
    private final int progression;
    private final ChatFormatting color;
    private String descriptionId;
    private ResourceLocation location;

    public SpellTier(int maxCharge, int upgradeLimit, int weight, int level, ChatFormatting color, int progression) {
        this.maxCharge = maxCharge;
        this.level = level;
        this.upgradeLimit = upgradeLimit;
        this.weight = weight;
        this.color = color;
        this.progression = progression;
    }

    public static SpellTier getWeightedRandomTier(RandomSource random, SpellTier ... tiers) {
        int totalWeight = 0;
        for (SpellTier tier : tiers) {
            totalWeight += tier.weight;
        }
        int randomiser = random.m_188503_(totalWeight);
        int cumulativeWeight = 0;
        for (SpellTier tier : tiers) {
            if (randomiser >= (cumulativeWeight += tier.weight)) continue;
            return tier;
        }
        return tiers[tiers.length - 1];
    }

    public SpellTier next() {
        List<SpellTier> tiers = Services.REGISTRY_UTIL.getTiers().stream().toList();
        int thisTierID = tiers.indexOf(this);
        return thisTierID < Services.REGISTRY_UTIL.getTiers().size() - 1 ? tiers.get(thisTierID + 1) : tiers.get(tiers.size() - 1);
    }

    public SpellTier previous() {
        List<SpellTier> tiers = Services.REGISTRY_UTIL.getTiers().stream().toList();
        int thisTierID = tiers.indexOf(this);
        return thisTierID > 0 ? tiers.get(thisTierID - 1) : tiers.get(0);
    }

    public Component getDescriptionFormatted() {
        return Component.m_237115_((String)this.getOrCreateDescriptionId()).m_130940_(this.color);
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.m_137492_((String)"tier", (ResourceLocation)Services.REGISTRY_UTIL.getTier(this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    @Nullable
    public ResourceLocation getOrCreateLocation() {
        if (this.location == null) {
            this.location = Services.REGISTRY_UTIL.getTier(this);
        }
        return this.location;
    }

    public ResourceLocation getLocation() {
        return this.getOrCreateLocation();
    }

    public void setLocation(ResourceLocation location) {
        if (this.location != null) {
            throw new IllegalStateException("Location already set for tier");
        }
        this.location = location;
    }

    public final boolean is(ResourceLocation location) {
        return location.equals((Object)this.getLocation());
    }

    public String toString() {
        return this.getLocation().toString();
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    public int getProgression() {
        return this.progression;
    }
}

