/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.spell;

import com.binaris.wizardry.api.EBLogger;

public enum SpellType {
    ATTACK("attack"),
    DEFENCE("defence"),
    UTILITY("utility"),
    MINION("minion"),
    BUFF("buff"),
    CONSTRUCT("construct"),
    PROJECTILE("projectile"),
    ALTERATION("alteration");

    private final String unlocalisedName;

    private SpellType(String name) {
        this.unlocalisedName = name;
    }

    public static SpellType fromName(String name) {
        for (SpellType type : SpellType.values()) {
            if (!type.unlocalisedName.equals(name) && !type.unlocalisedName.equals(name.toLowerCase())) continue;
            return type;
        }
        EBLogger.error("No such spell type with unlocalized name: '%s', maybe some spell is bad registered?!".formatted(name), new Object[0]);
        return UTILITY;
    }

    public String getUnlocalisedName() {
        return this.unlocalisedName;
    }

    public String getDisplayName() {
        return "spelltype." + this.unlocalisedName;
    }
}

