/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.spell.internal;

import com.binaris.wizardry.setup.registries.WandUpgrades;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;

public final class SpellModifiers {
    public static final String POTENCY = "potency";
    public static final String COST = "cost";
    public static final String CHARGEUP = "chargeup";
    public static final String PROGRESSION = "progression";
    private final Map<String, Float> multiplierMap = new HashMap<String, Float>();
    private final Map<String, Float> syncedMultiplierMap = new HashMap<String, Float>();

    public static SpellModifiers fromTag(CompoundTag tag) {
        SpellModifiers modifiers = new SpellModifiers();
        tag.m_128431_().forEach(key -> modifiers.set((String)key, tag.m_128457_(key), true));
        return modifiers;
    }

    public CompoundTag toTag() {
        CompoundTag nbt = new CompoundTag();
        this.multiplierMap.forEach((arg_0, arg_1) -> ((CompoundTag)nbt).m_128350_(arg_0, arg_1));
        return nbt;
    }

    public SpellModifiers combine(SpellModifiers modifiers) {
        for (String key : Sets.union(this.multiplierMap.keySet(), modifiers.multiplierMap.keySet())) {
            float newValue = this.get(key) * modifiers.get(key);
            boolean sync = this.syncedMultiplierMap.containsKey(key) || modifiers.syncedMultiplierMap.containsKey(key);
            this.set(key, newValue, sync);
        }
        return this;
    }

    public SpellModifiers set(Item upgrade, float multiplier, boolean needsSyncing) {
        this.set(WandUpgrades.getIdentifier(upgrade), multiplier, needsSyncing);
        return this;
    }

    public SpellModifiers set(String key, float multiplier, boolean needsSyncing) {
        this.multiplierMap.put(key, Float.valueOf(multiplier));
        if (needsSyncing) {
            this.syncedMultiplierMap.put(key, Float.valueOf(multiplier));
        }
        return this;
    }

    public float get(Item upgrade) {
        return this.get(WandUpgrades.getIdentifier(upgrade));
    }

    public float get(String key) {
        Float value = this.multiplierMap.get(key);
        return value == null ? 1.0f : value.floatValue();
    }

    public Map<String, Float> getMultipliers() {
        return this.multiplierMap;
    }

    public Map<String, Float> getSyncedMultipliers() {
        return this.syncedMultiplierMap;
    }

    public void reset() {
        this.multiplierMap.clear();
        this.syncedMultiplierMap.clear();
    }
}

